/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver.expr;

import com.github.zafarkhaja.semver.Parser;
import com.github.zafarkhaja.semver.Version;
import com.github.zafarkhaja.semver.compiling.UnexpectedTokenException;
import com.github.zafarkhaja.semver.expr.CompositeExpression;
import com.github.zafarkhaja.semver.expr.ExprLexer;
import com.github.zafarkhaja.semver.expr.Expression;
import com.github.zafarkhaja.semver.util.Stream;
import com.github.zafarkhaja.semver.util.UnexpectedElementException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.function.Predicate;

public class ExpressionParser
implements Parser<Expression> {
    private final ExprLexer lexer;
    private Stream<ExprLexer.ExprToken> tokens;

    ExpressionParser(ExprLexer lexer) {
        this.lexer = lexer;
    }

    public static Parser<Expression> newInstance() {
        return new ExpressionParser(new ExprLexer());
    }

    @Override
    public Expression parse(String input) {
        this.tokens = this.lexer.tokenize(input);
        CompositeExpression expr = this.parseSemVerExpression();
        this.consumeNextToken(ExprLexer.ExprToken.Type.EOI);
        return expr;
    }

    private CompositeExpression parseSemVerExpression() {
        CompositeExpression expr;
        if (this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.NOT})) {
            this.tokens.consume();
            this.consumeNextToken(ExprLexer.ExprToken.Type.LEFT_PAREN);
            expr = CompositeExpression.Helper.not(this.parseSemVerExpression());
            this.consumeNextToken(ExprLexer.ExprToken.Type.RIGHT_PAREN);
        } else if (this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.LEFT_PAREN})) {
            this.consumeNextToken(ExprLexer.ExprToken.Type.LEFT_PAREN);
            expr = this.parseSemVerExpression();
            this.consumeNextToken(ExprLexer.ExprToken.Type.RIGHT_PAREN);
        } else {
            expr = this.parseRange();
        }
        return this.parseMoreExpressions(expr);
    }

    private CompositeExpression parseMoreExpressions(CompositeExpression expr) {
        if (this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.AND})) {
            this.tokens.consume();
            expr = ((CompositeExpression)expr).and((Predicate)this.parseSemVerExpression());
        } else if (this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.OR})) {
            this.tokens.consume();
            expr = ((CompositeExpression)expr).or((Predicate)this.parseSemVerExpression());
        }
        return expr;
    }

    private CompositeExpression parseRange() {
        if (this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.TILDE})) {
            return this.parseTildeRange();
        }
        if (this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.CARET})) {
            return this.parseCaretRange();
        }
        if (this.isWildcardRange()) {
            return this.parseWildcardRange();
        }
        if (this.isHyphenRange()) {
            return this.parseHyphenRange();
        }
        if (this.isPartialVersionRange()) {
            return this.parsePartialVersionRange();
        }
        return this.parseComparisonRange();
    }

    private CompositeExpression parseComparisonRange() {
        CompositeExpression expr;
        ExprLexer.ExprToken token = this.tokens.lookahead();
        switch ((ExprLexer.ExprToken.Type)token.type) {
            case EQUAL: {
                this.tokens.consume();
                expr = CompositeExpression.Helper.eq(this.parseVersion());
                break;
            }
            case NOT_EQUAL: {
                this.tokens.consume();
                expr = CompositeExpression.Helper.neq(this.parseVersion());
                break;
            }
            case GREATER: {
                this.tokens.consume();
                expr = CompositeExpression.Helper.gt(this.parseVersion());
                break;
            }
            case GREATER_EQUAL: {
                this.tokens.consume();
                expr = CompositeExpression.Helper.gte(this.parseVersion());
                break;
            }
            case LESS: {
                this.tokens.consume();
                expr = CompositeExpression.Helper.lt(this.parseVersion());
                break;
            }
            case LESS_EQUAL: {
                this.tokens.consume();
                expr = CompositeExpression.Helper.lte(this.parseVersion());
                break;
            }
            default: {
                expr = CompositeExpression.Helper.eq(this.parseVersion());
            }
        }
        return expr;
    }

    private CompositeExpression parseTildeRange() {
        this.consumeNextToken(ExprLexer.ExprToken.Type.TILDE);
        int major = Integer.parseInt(this.consumeNextToken((ExprLexer.ExprToken.Type[])new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.NUMERIC}).lexeme);
        if (!this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.DOT})) {
            return CompositeExpression.Helper.gte(this.versionFor(major)).and((Predicate)CompositeExpression.Helper.lt(this.versionFor(major + 1)));
        }
        this.consumeNextToken(ExprLexer.ExprToken.Type.DOT);
        int minor = Integer.parseInt(this.consumeNextToken((ExprLexer.ExprToken.Type[])new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.NUMERIC}).lexeme);
        if (!this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.DOT})) {
            return CompositeExpression.Helper.gte(this.versionFor(major, minor)).and((Predicate)CompositeExpression.Helper.lt(this.versionFor(major, minor + 1)));
        }
        this.consumeNextToken(ExprLexer.ExprToken.Type.DOT);
        int patch = Integer.parseInt(this.consumeNextToken((ExprLexer.ExprToken.Type[])new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.NUMERIC}).lexeme);
        return CompositeExpression.Helper.gte(this.versionFor(major, minor, patch)).and((Predicate)CompositeExpression.Helper.lt(this.versionFor(major, minor + 1)));
    }

    private CompositeExpression parseCaretRange() {
        this.consumeNextToken(ExprLexer.ExprToken.Type.CARET);
        int major = Integer.parseInt(this.consumeNextToken((ExprLexer.ExprToken.Type[])new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.NUMERIC}).lexeme);
        if (!this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.DOT})) {
            return CompositeExpression.Helper.gte(this.versionFor(major)).and((Predicate)CompositeExpression.Helper.lt(this.versionFor(major + 1)));
        }
        this.consumeNextToken(ExprLexer.ExprToken.Type.DOT);
        int minor = Integer.parseInt(this.consumeNextToken((ExprLexer.ExprToken.Type[])new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.NUMERIC}).lexeme);
        if (!this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.DOT})) {
            Version lower = this.versionFor(major, minor);
            Version upper = major > 0 ? lower.incrementMajorVersion() : lower.incrementMinorVersion();
            return CompositeExpression.Helper.gte(lower).and((Predicate)CompositeExpression.Helper.lt(upper));
        }
        this.consumeNextToken(ExprLexer.ExprToken.Type.DOT);
        int patch = Integer.parseInt(this.consumeNextToken((ExprLexer.ExprToken.Type[])new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.NUMERIC}).lexeme);
        Version version = this.versionFor(major, minor, patch);
        CompositeExpression gte = CompositeExpression.Helper.gte(version);
        if (major > 0) {
            return gte.and((Predicate)CompositeExpression.Helper.lt(version.incrementMajorVersion()));
        }
        if (minor > 0) {
            return gte.and((Predicate)CompositeExpression.Helper.lt(version.incrementMinorVersion()));
        }
        if (patch > 0) {
            return gte.and((Predicate)CompositeExpression.Helper.lt(version.incrementPatchVersion()));
        }
        return CompositeExpression.Helper.eq(version);
    }

    private boolean isWildcardRange() {
        return this.isVersionFollowedBy(ExprLexer.ExprToken.Type.WILDCARD);
    }

    private CompositeExpression parseWildcardRange() {
        if (this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.WILDCARD})) {
            this.tokens.consume();
            if (this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.DOT})) {
                this.tokens.consume();
                this.tokens.consume(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.WILDCARD});
            }
            if (this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.DOT})) {
                this.tokens.consume();
                this.tokens.consume(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.WILDCARD});
            }
            return CompositeExpression.Helper.gte(this.versionFor(0, 0, 0));
        }
        int major = Integer.parseInt(this.consumeNextToken((ExprLexer.ExprToken.Type[])new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.NUMERIC}).lexeme);
        this.consumeNextToken(ExprLexer.ExprToken.Type.DOT);
        if (this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.WILDCARD})) {
            this.tokens.consume();
            if (this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.DOT})) {
                this.tokens.consume();
                this.tokens.consume(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.WILDCARD});
            }
            return CompositeExpression.Helper.gte(this.versionFor(major)).and((Predicate)CompositeExpression.Helper.lt(this.versionFor(major + 1)));
        }
        int minor = Integer.parseInt(this.consumeNextToken((ExprLexer.ExprToken.Type[])new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.NUMERIC}).lexeme);
        this.consumeNextToken(ExprLexer.ExprToken.Type.DOT);
        this.consumeNextToken(ExprLexer.ExprToken.Type.WILDCARD);
        return CompositeExpression.Helper.gte(this.versionFor(major, minor)).and((Predicate)CompositeExpression.Helper.lt(this.versionFor(major, minor + 1)));
    }

    private boolean isHyphenRange() {
        return this.isVersionFollowedBy(ExprLexer.ExprToken.Type.HYPHEN);
    }

    private CompositeExpression parseHyphenRange() {
        CompositeExpression gte = CompositeExpression.Helper.gte(this.parseVersion());
        this.consumeNextToken(ExprLexer.ExprToken.Type.HYPHEN);
        return gte.and((Predicate)CompositeExpression.Helper.lte(this.parseVersion()));
    }

    private boolean isPartialVersionRange() {
        if (!this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.NUMERIC})) {
            return false;
        }
        EnumSet<ExprLexer.ExprToken.Type> expected = EnumSet.complementOf(EnumSet.of(ExprLexer.ExprToken.Type.NUMERIC, ExprLexer.ExprToken.Type.DOT));
        return this.tokens.positiveLookaheadUntil(5, expected.toArray(new ExprLexer.ExprToken.Type[expected.size()]));
    }

    private CompositeExpression parsePartialVersionRange() {
        int major = Integer.parseInt(this.consumeNextToken((ExprLexer.ExprToken.Type[])new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.NUMERIC}).lexeme);
        if (!this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.DOT})) {
            return CompositeExpression.Helper.gte(this.versionFor(major)).and((Predicate)CompositeExpression.Helper.lt(this.versionFor(major + 1)));
        }
        this.consumeNextToken(ExprLexer.ExprToken.Type.DOT);
        int minor = Integer.parseInt(this.consumeNextToken((ExprLexer.ExprToken.Type[])new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.NUMERIC}).lexeme);
        return CompositeExpression.Helper.gte(this.versionFor(major, minor)).and((Predicate)CompositeExpression.Helper.lt(this.versionFor(major, minor + 1)));
    }

    private Version parseVersion() {
        int major = Integer.parseInt(this.consumeNextToken((ExprLexer.ExprToken.Type[])new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.NUMERIC}).lexeme);
        int minor = 0;
        if (this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.DOT})) {
            this.tokens.consume();
            minor = Integer.parseInt(this.consumeNextToken((ExprLexer.ExprToken.Type[])new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.NUMERIC}).lexeme);
        }
        int patch = 0;
        if (this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.DOT})) {
            this.tokens.consume();
            patch = Integer.parseInt(this.consumeNextToken((ExprLexer.ExprToken.Type[])new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.NUMERIC}).lexeme);
        }
        StringBuilder pre = new StringBuilder();
        if (this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.HYPHEN}) && this.tokens.lookahead((int)2).type == ExprLexer.ExprToken.Type.ALPHA_NUMERIC) {
            this.tokens.consume();
            while (this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.ALPHA_NUMERIC, ExprLexer.ExprToken.Type.NUMERIC, ExprLexer.ExprToken.Type.DOT})) {
                pre.append(((ExprLexer.ExprToken)this.tokens.consume((Stream.ElementType[])new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.ALPHA_NUMERIC, ExprLexer.ExprToken.Type.NUMERIC, ExprLexer.ExprToken.Type.DOT})).lexeme);
            }
        }
        StringBuilder build = new StringBuilder();
        if (this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.PLUS})) {
            this.tokens.consume();
            while (this.tokens.positiveLookahead(new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.ALPHA_NUMERIC, ExprLexer.ExprToken.Type.NUMERIC, ExprLexer.ExprToken.Type.DOT})) {
                build.append(((ExprLexer.ExprToken)this.tokens.consume((Stream.ElementType[])new ExprLexer.ExprToken.Type[]{ExprLexer.ExprToken.Type.ALPHA_NUMERIC, ExprLexer.ExprToken.Type.NUMERIC, ExprLexer.ExprToken.Type.DOT})).lexeme);
            }
        }
        Version vtemp = Version.forIntegers(major, minor, patch);
        if (pre.length() != 0) {
            vtemp = vtemp.setPreReleaseVersion(pre.toString());
        }
        if (build.length() != 0) {
            vtemp = vtemp.setBuildMetadata(build.toString());
        }
        return vtemp;
    }

    private boolean isVersionFollowedBy(Stream.ElementType<ExprLexer.ExprToken> type) {
        Iterator<ExprLexer.ExprToken> it = this.tokens.iterator();
        ExprLexer.ExprToken lookahead = null;
        ExprLexer.ExprToken lookahead2 = null;
        for (int i = 0; i < 2; ++i) {
            block14: {
                block13: {
                    if (!it.hasNext()) break block13;
                    lookahead = it.next();
                    if (lookahead.type == ExprLexer.ExprToken.Type.NUMERIC) break block14;
                }
                if (it.hasNext()) {
                    lookahead2 = it.next();
                    if (lookahead2.type == ExprLexer.ExprToken.Type.NUMERIC || lookahead2.type == ExprLexer.ExprToken.Type.HYPHEN || lookahead2.type == ExprLexer.ExprToken.Type.PLUS) break;
                }
                return type.isMatchedBy(lookahead);
            }
            if (it.hasNext()) {
                lookahead = it.next();
                if (lookahead.type == ExprLexer.ExprToken.Type.DOT) continue;
            }
            return type.isMatchedBy(lookahead);
        }
        ExprLexer.ExprToken exprToken = lookahead = lookahead2 == null ? it.next() : lookahead2;
        if (lookahead.type == ExprLexer.ExprToken.Type.NUMERIC && it.hasNext()) {
            lookahead = it.next();
        }
        if (lookahead.type == ExprLexer.ExprToken.Type.HYPHEN && it.hasNext()) {
            ExprLexer.ExprToken f = it.next();
            if (f.type == ExprLexer.ExprToken.Type.ALPHA_NUMERIC) {
                while (it.hasNext()) {
                    lookahead = it.next();
                    if (lookahead.type == ExprLexer.ExprToken.Type.ALPHA_NUMERIC || lookahead.type == ExprLexer.ExprToken.Type.NUMERIC || lookahead.type == ExprLexer.ExprToken.Type.DOT) continue;
                }
            }
        }
        if (lookahead.type == ExprLexer.ExprToken.Type.PLUS && it.hasNext()) {
            ExprLexer.ExprToken f = it.next();
            if (f.type == ExprLexer.ExprToken.Type.ALPHA_NUMERIC || f.type == ExprLexer.ExprToken.Type.NUMERIC) {
                while (it.hasNext()) {
                    lookahead = it.next();
                    if (lookahead.type == ExprLexer.ExprToken.Type.ALPHA_NUMERIC || lookahead.type == ExprLexer.ExprToken.Type.NUMERIC || lookahead.type == ExprLexer.ExprToken.Type.DOT) continue;
                    break;
                }
            }
        }
        return type.isMatchedBy(lookahead);
    }

    private Version versionFor(int major) {
        return this.versionFor(major, 0, 0);
    }

    private Version versionFor(int major, int minor) {
        return this.versionFor(major, minor, 0);
    }

    private Version versionFor(int major, int minor, int patch) {
        return Version.forIntegers(major, minor, patch);
    }

    private ExprLexer.ExprToken consumeNextToken(ExprLexer.ExprToken.Type ... expected) {
        try {
            return (ExprLexer.ExprToken)this.tokens.consume(expected);
        }
        catch (UnexpectedElementException e) {
            throw new UnexpectedTokenException(e);
        }
    }
}

