/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.scripteditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.painter.BusyPainter;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.openide.awt.Mnemonics;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ChangeType;
import rs.co.ast.aspen.api.service.ClientScriptsUpdateReport;
import rs.co.ast.aspen.api.service.Script;
import rs.co.ast.aspen.api.service.ScriptTransfer;
import rs.co.ast.aspen.api.service.ScriptType;
import rs.co.ast.aspen.api.service.ScriptsUpdateReport;
import rs.co.ast.aspen.gui.module.scripteditor.CurrentScriptPanel;
import rs.co.ast.aspen.gui.module.scripteditor.DefferedDocumentListener;
import rs.co.ast.aspen.gui.module.scripteditor.DiffPanel;
import rs.co.ast.aspen.gui.module.scripteditor.LegendPanel;
import rs.co.ast.aspen.gui.module.scripteditor.RecoverScriptsEvent;
import rs.co.ast.aspen.gui.module.scripteditor.RecoverScriptsEventListener;
import rs.co.ast.aspen.gui.module.scripteditor.RecoverScriptsEventSupport;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptComparatorByOrder;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptEditorTopComponent;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptTypeComboBoxModel;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptUpdate;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptUpdateTableModel;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptUpdateTableRenderer;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptUpdatedEvent;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptUpdatedEventListener;
import rs.co.ast.aspen.gui.module.scripteditor.UpdateTableInScriptUpdateTopComponent;

@TopComponent.Description(preferredID="ScriptUpdateTopComponent", iconBase="update.png", persistenceType=2)
public final class ScriptUpdateTopComponent
extends TopComponent {
    private static final Logger logger = Logger.getLogger(ScriptUpdateTopComponent.class.getName());
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private ScriptUpdateTableModel tableModel = new ScriptUpdateTableModel();
    private ScriptTypeComboBoxModel scriptTypeModel = new ScriptTypeComboBoxModel();
    private final ScheduledExecutorService scriptsUpdater = Executors.newSingleThreadScheduledExecutor();
    private CurrentScriptPanel currentScriptPanel = new CurrentScriptPanel();
    private DiffPanel diffPanel = new DiffPanel();
    private Map<ScriptType, List<Script>> scriptsOfType;
    private List<Script> allScripts;
    private RecoverScriptsEventSupport recoverScriptsEventSupport = new RecoverScriptsEventSupport();
    private Lookup.Result<UpdateTableInScriptUpdateTopComponent> lr = Utilities.actionsGlobalContext().lookupResult(UpdateTableInScriptUpdateTopComponent.class);
    private JButton bRefresh;
    private JButton bShowLegend;
    private JCheckBox cbCaseSensitiveKeyword;
    private JComboBox<String> cbScriptType;
    private JXCollapsiblePane cpLegend;
    private JLabel jLabel1;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JXBusyLabel lLoading;
    private JTable tScripts;
    private JTabbedPane tabPane;
    private JTextField tfKeywords;

    public ScriptUpdateTopComponent() {
        this.initComponents();
        this.lr.allInstances();
        this.lr.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent le) {
                Lookup.Result lr = (Lookup.Result)le.getSource();
                Collection instance = lr.allInstances();
                for (Object o : instance) {
                    UpdateTableInScriptUpdateTopComponent utm;
                    if (!(o instanceof UpdateTableInScriptUpdateTopComponent) || !(utm = (UpdateTableInScriptUpdateTopComponent)o).toUpdate()) continue;
                    new Updater().execute();
                    ((UpdateTableInScriptUpdateTopComponent)o).setToUpdate(false);
                }
            }
        });
        this.tabPane.addTab(NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.currentScriptPanel.TabConstraints.tabTitle"), this.currentScriptPanel);
        this.tabPane.addTab(NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.diffPanel.TabConstraints.tabTitle"), this.diffPanel);
        this.tabPane.setSelectedIndex(1);
        this.cpLegend.setLayout((LayoutManager)new BorderLayout());
        this.cpLegend.add((Component)new LegendPanel(), (Object)"Center");
        this.bShowLegend.addActionListener(this.cpLegend.getActionMap().get("toggle"));
        this.setName(NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"CTL_ScriptUpdateTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"HINT_ScriptUpdateTopComponent"));
        this.tScripts.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ScriptUpdateTopComponent.this.tScripts.getSelectedRow() > -1) {
                    ScriptUpdate script = (ScriptUpdate)ScriptUpdateTopComponent.this.tableModel.getValueAt(ScriptUpdateTopComponent.this.tScripts.getSelectedRow(), 0);
                    if (script == null) {
                        script = new ScriptUpdate("id", "empty script", "", "", ScriptType.ROUTING, ChangeType.NONE, 0L, true, "", "", 1L, "javascript");
                    }
                    ScriptUpdateTopComponent.this.currentScriptPanel.setScript(script.getPrevScript());
                    ScriptUpdateTopComponent.this.diffPanel.setScript(script);
                    ScriptUpdateTopComponent.this.diff(script);
                }
            }
        });
        this.tScripts.setDefaultRenderer(ScriptUpdate.class, new ScriptUpdateTableRenderer());
        this.tScripts.setSelectionMode(0);
        this.tScripts.setRowSelectionAllowed(true);
        this.tScripts.setFillsViewportHeight(true);
        this.cbScriptType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptType scriptType = ScriptUpdateTopComponent.this.scriptTypeModel.getSelectedItem(ScriptUpdateTopComponent.this.scriptTypeModel.getSelectedIndex());
                ScriptUpdateTopComponent.this.refreshTable(scriptType);
                ScriptUpdateTopComponent.this.diffPanel.setSelectedScriptType(scriptType);
                ScriptUpdateTopComponent.this.currentScriptPanel.setScript("");
                if (ScriptUpdateTopComponent.this.tableModel.getRowCount() > 0) {
                    ScriptUpdateTopComponent.this.tScripts.setRowSelectionInterval(0, 0);
                }
                switch (scriptType) {
                    case CORRELATION: 
                    case ROUTING: 
                    case NOTIFICATION_PREPROCESSING: 
                    case SCHEDULED: 
                    case UTILITY_FUNCTIONS: {
                        ScriptUpdateTopComponent.this.currentScriptPanel.setSyntaxEditingStyle("text/javascript");
                        break;
                    }
                    case VISUALISATION_CONFIGURATION: 
                    case VISUALISATION_RULESET: {
                        ScriptUpdateTopComponent.this.currentScriptPanel.setSyntaxEditingStyle("text/visscript");
                    }
                }
            }
        });
        this.cbScriptType.setModel(this.scriptTypeModel);
        this.diffPanel.addScriptUpdatedEventListener(new ScriptUpdatedEventListener(){

            @Override
            public void onScriptUpdated(ScriptUpdatedEvent event) {
                new Updater().execute();
                RecoverScriptsEvent RCEvent = new RecoverScriptsEvent(event);
                ScriptUpdateTopComponent.this.recoverScriptsEventSupport.fireUpdateTableActionEventListener(RCEvent);
            }

            @Override
            public void beforeScriptUpdated(ScriptUpdatedEvent event) {
                RecoverScriptsEvent RCEvent = new RecoverScriptsEvent(event);
                ScriptUpdateTopComponent.this.recoverScriptsEventSupport.fireRecoverScriptsActionEventListener(RCEvent);
            }
        });
        final DefferedDocumentListener searchScriptActionListener = new DefferedDocumentListener(500, e -> this.tableModel.filterScripts(this.tfKeywords.getText(), this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex()), this.cbCaseSensitiveKeyword.isSelected()), true);
        this.cbCaseSensitiveKeyword.addActionListener(e -> {
            if (!this.tfKeywords.getText().equals(NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.tfKeywords.text"))) {
                this.tableModel.filterScripts(this.tfKeywords.getText(), this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex()), this.cbCaseSensitiveKeyword.isSelected());
            }
        });
        this.tfKeywords.getDocument().addDocumentListener(searchScriptActionListener);
        this.tfKeywords.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (ScriptUpdateTopComponent.this.tfKeywords.getText().equals(NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.tfKeywords.text"))) {
                    ScriptUpdateTopComponent.this.tfKeywords.setText("");
                    ScriptUpdateTopComponent.this.tfKeywords.setForeground(Color.BLACK);
                }
                searchScriptActionListener.start();
            }

            @Override
            public void focusLost(FocusEvent e) {
                searchScriptActionListener.stop();
            }
        });
        this.scriptsUpdater.scheduleAtFixedRate(new Updater(), 0L, 60L, TimeUnit.MINUTES);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.tabPane = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.cbScriptType = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tScripts = new JTable();
        this.bRefresh = new JButton();
        this.lLoading = new JXBusyLabel();
        this.bShowLegend = new JButton();
        this.cpLegend = new JXCollapsiblePane();
        this.tfKeywords = new JTextField();
        this.cbCaseSensitiveKeyword = new JCheckBox();
        this.jSplitPane1.setDividerLocation(320);
        this.jSplitPane1.setResizeWeight(0.3);
        this.jSplitPane1.setRightComponent(this.tabPane);
        this.cbScriptType.setFont(new Font("Dialog", 0, 12));
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.jLabel1.text"));
        this.tScripts.setModel(this.tableModel);
        this.jScrollPane1.setViewportView(this.tScripts);
        this.bRefresh.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/arrow_refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bRefresh, (String)NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.bRefresh.text"));
        this.bRefresh.setMaximumSize(new Dimension(50, 15));
        this.bRefresh.setMinimumSize(new Dimension(50, 15));
        this.bRefresh.setPreferredSize(new Dimension(32, 32));
        this.bRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptUpdateTopComponent.this.bRefreshActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lLoading, (String)NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.lLoading.text"));
        this.lLoading.setDelay(50);
        this.lLoading.setDirection(BusyPainter.Direction.RIGHT);
        Mnemonics.setLocalizedText((AbstractButton)this.bShowLegend, (String)NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.bShowLegend.text"));
        this.cpLegend.setCollapsed(true);
        this.tfKeywords.setForeground(new Color(153, 153, 153));
        this.tfKeywords.setText(NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.tfKeywords.text"));
        this.tfKeywords.setToolTipText(NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.tfKeywords.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbCaseSensitiveKeyword, (String)NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.cbCaseSensitiveKeyword.text"));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.cpLegend, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.cbScriptType, 0, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 182, Short.MAX_VALUE).addComponent((Component)this.lLoading, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bRefresh, -2, 32, -2)).addComponent(this.bShowLegend, GroupLayout.Alignment.TRAILING, -1, 295, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.tfKeywords, -2, 175, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbCaseSensitiveKeyword).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bRefresh, -2, -1, -2).addComponent(this.jLabel1, -2, 32, -2).addComponent((Component)this.lLoading, -2, 32, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbScriptType, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfKeywords, -2, -1, -2).addComponent(this.cbCaseSensitiveKeyword)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 424, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cpLegend, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bShowLegend).addContainerGap()));
        this.jSplitPane1.setLeftComponent(this.jPanel3);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 1000, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
    }

    private void bRefreshActionPerformed(ActionEvent evt) {
        new Updater().execute();
    }

    private void diff(final ScriptUpdate script) {
        SwingWorker<Component, Void> sw = new SwingWorker<Component, Void>(){

            @Override
            protected Component doInBackground() throws Exception {
                if (script.getScript() == null) {
                    script.setScript("");
                }
                if (script.getPrevScript() == null) {
                    script.setPrevScript("");
                }
                try {
                    StreamSource local1 = StreamSource.createSource((String)script.getName(), (String)NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.diff.current"), (String)"text/x-java", (Reader)new StringReader(script.getPrevScript()));
                    StreamSource local2 = StreamSource.createSource((String)script.getName(), (String)NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.diff.updated"), (String)"text/x-java", (Reader)new StringReader(script.getScript()));
                    DiffView view = Diff.getDefault().createDiff(local1, local2);
                    return view.getComponent();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            }

            @Override
            protected void done() {
                try {
                    Component component = (Component)this.get();
                    if (component != null) {
                        ScriptUpdateTopComponent.this.diffPanel.removeAllComponents();
                        ScriptUpdateTopComponent.this.diffPanel.addComponent(component);
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        sw.execute();
    }

    private void refreshTable(ScriptType type) {
        if (type == ScriptType.VISUALISATION_CONFIGURATION || type == ScriptType.VISUALISATION_RULESET) {
            this.tableModel.sortScriptsByName(type);
        } else {
            this.tableModel.sortScriptsByOrder(type);
        }
    }

    public void componentOpened() {
    }

    public void componentClosed() {
        this.scriptsUpdater.shutdownNow();
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void toggleLoading() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScriptUpdateTopComponent.this.lLoading.setBusy(!ScriptUpdateTopComponent.this.lLoading.isBusy());
            }
        });
    }

    public void addRecoverScriptsEventListener(RecoverScriptsEventListener listener) {
        this.recoverScriptsEventSupport.addRecoverScriptsEventListener(listener);
    }

    public void removeRecoverScriptsEventListener(RecoverScriptsEventListener listener) {
        this.recoverScriptsEventSupport.removeRecoverScriptsEventListener(listener);
    }

    public void fireRecoverScriptsEventListener(RecoverScriptsEvent event) {
        this.recoverScriptsEventSupport.fireRecoverScriptsActionEventListener(event);
    }

    private ScriptEditorTopComponent findTopComponent() {
        Set opened = WindowManager.getDefault().getRegistry().getOpened();
        for (TopComponent tc : opened) {
            if (!(tc instanceof ScriptEditorTopComponent)) continue;
            return (ScriptEditorTopComponent)tc;
        }
        return null;
    }

    public class Updater
    extends SwingWorker<List<ScriptUpdate>, Void> {
        @Override
        protected List<ScriptUpdate> doInBackground() {
            block3: {
                try {
                    ScriptUpdateTopComponent.this.toggleLoading();
                    if (!ScriptUpdateTopComponent.this.apiService.heartbeat()) break block3;
                    ScriptUpdateTopComponent.this.allScripts = (List)ScriptUpdateTopComponent.this.apiService.getAllScripts();
                    this.scriptsToScriptsOfType();
                    ClientScriptsUpdateReport clientScriptUpdateReport = this.createClientScriptsUpdateReport();
                    ScriptsUpdateReport updateReport = ScriptUpdateTopComponent.this.apiService.checkScriptsForUpdate(clientScriptUpdateReport);
                    if (updateReport.getErrorMessage() != null) {
                        NotificationDisplayer.getDefault().notify(NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.update.error.title"), (Icon)new ImageIcon(), updateReport.getErrorMessage().getMessage(), null);
                        break block3;
                    }
                    List<ScriptUpdate> scriptsUpdateToTableModel = this.scriptsUpdateToTableModel(updateReport);
                    return scriptsUpdateToTableModel;
                }
                catch (ApiServiceException_Exception ex) {
                    return null;
                }
            }
            return null;
        }

        private void scriptsToScriptsOfType() {
            ScriptUpdateTopComponent.this.scriptsOfType = new HashMap<ScriptType, List<Script>>();
            for (ScriptType t : ScriptType.values()) {
                ArrayList<Script> list = new ArrayList<Script>();
                for (Script s : ScriptUpdateTopComponent.this.allScripts) {
                    if (!s.getType().equals((Object)t)) continue;
                    list.add(s);
                }
                ScriptUpdateTopComponent.this.scriptsOfType.put(t, list);
            }
        }

        private List<ScriptUpdate> scriptsUpdateToTableModel(ScriptsUpdateReport updateReport) {
            ArrayList<ScriptUpdate> scriptUpdates = new ArrayList<ScriptUpdate>();
            for (ScriptsUpdateReport.Report.Entry entry : updateReport.getReport().getEntry()) {
                String id = entry.getKey();
                ScriptTransfer st = entry.getValue();
                Script script = this.findScriptById(id);
                ScriptUpdate su = script != null ? (st.getChangeType() == ChangeType.RED ? new ScriptUpdate(id, st.getName(), st.getDescription(), "", st.getType(), st.getChangeType(), script.getOrder(), script.isEnabled(), script.getScript(), st.getHash(), st.getVersion(), st.getLanguage()) : new ScriptUpdate(id, st.getName(), st.getDescription(), st.getScript(), st.getType(), st.getChangeType(), script.getOrder(), script.isEnabled(), script.getScript(), st.getHash(), st.getVersion(), st.getLanguage())) : new ScriptUpdate(id, st.getName(), st.getDescription(), st.getScript(), st.getType(), st.getChangeType(), this.findLastOrderByScriptType(st.getType()), st.isEnabled(), "", st.getHash(), st.getVersion(), st.getLanguage());
                scriptUpdates.add(su);
            }
            return scriptUpdates;
        }

        private long findLastOrderByScriptType(ScriptType type) {
            List<Script> scriptsByType = ScriptUpdateTopComponent.this.scriptsOfType.get(type);
            Collections.sort(scriptsByType, new ScriptComparatorByOrder());
            if (scriptsByType.isEmpty()) {
                return 0L;
            }
            if (scriptsByType.size() == 1) {
                return 1L;
            }
            return scriptsByType.get(scriptsByType.size() - 1).getOrder();
        }

        private Script findScriptById(String id) {
            if (ScriptUpdateTopComponent.this.allScripts != null) {
                for (Script script : ScriptUpdateTopComponent.this.allScripts) {
                    if (!script.getId().equalsIgnoreCase(id)) continue;
                    return script;
                }
            }
            return null;
        }

        private ClientScriptsUpdateReport createClientScriptsUpdateReport() {
            ClientScriptsUpdateReport clientScriptUpdateReport = new ClientScriptsUpdateReport();
            clientScriptUpdateReport.setReport(new ClientScriptsUpdateReport.Report());
            for (List<Script> scripts : ScriptUpdateTopComponent.this.scriptsOfType.values()) {
                for (Script script : scripts) {
                    ClientScriptsUpdateReport.Report.Entry entry = new ClientScriptsUpdateReport.Report.Entry();
                    entry.setKey(script.getId());
                    entry.setValue(script);
                    clientScriptUpdateReport.getReport().getEntry().add(entry);
                }
            }
            return clientScriptUpdateReport;
        }

        @Override
        protected void done() {
            try {
                if (this.get() == null) {
                    JOptionPane.showMessageDialog(null, NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.serverNotAvailable.message"), NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.serverNotAvailable.title"), 0);
                } else if (((List)this.get()).isEmpty()) {
                    JOptionPane.showMessageDialog(null, NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.scriptsUpToDate.message"), NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.scriptsUpToDate.title"), 1);
                } else {
                    List scriptsUpdateToTableModel = (List)this.get();
                    ScriptUpdateTopComponent.this.tableModel.setData(scriptsUpdateToTableModel);
                    ScriptUpdateTopComponent.this.diffPanel.setScripts(scriptsUpdateToTableModel);
                    ScriptUpdateTopComponent.this.tableModel.filterScripts(ScriptUpdateTopComponent.this.tfKeywords.getText().equals(NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.tfKeywords.text")) ? "" : ScriptUpdateTopComponent.this.tfKeywords.getText(), ScriptUpdateTopComponent.this.scriptTypeModel.getSelectedItem(ScriptUpdateTopComponent.this.scriptTypeModel.getSelectedIndex()), ScriptUpdateTopComponent.this.cbCaseSensitiveKeyword.isSelected());
                    ScriptUpdateTopComponent.this.refreshTable(ScriptUpdateTopComponent.this.scriptTypeModel.getSelectedItem(ScriptUpdateTopComponent.this.scriptTypeModel.getSelectedIndex()));
                    if (ScriptUpdateTopComponent.this.tableModel.getRowCount() > 0) {
                        ScriptUpdateTopComponent.this.tScripts.setRowSelectionInterval(0, 0);
                    } else {
                        ScriptUpdateTopComponent.this.tabPane.setSelectedIndex(0);
                        ScriptUpdateTopComponent.this.currentScriptPanel.setScript("");
                        ScriptUpdateTopComponent.this.diffPanel.removeAllComponents();
                    }
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.serverNotAvailable.message"), NbBundle.getMessage(ScriptUpdateTopComponent.class, (String)"ScriptUpdateTopComponent.serverNotAvailable.title"), 0);
            }
            finally {
                ScriptUpdateTopComponent.this.toggleLoading();
            }
        }
    }
}

