/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf;

import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.InsetsUIResource;
import org.netbeans.swing.laf.flatlaf.DPISafeBorder;
import org.netbeans.swing.laf.flatlaf.FlatLafPrefs;
import org.netbeans.swing.laf.flatlaf.ui.FlatTabControlIcon;
import org.netbeans.swing.plaf.LFCustoms;
import org.openide.util.Utilities;

public class FlatLFCustoms
extends LFCustoms {
    private static final ModifiableColor unifiedBackground = new ModifiableColor();
    private static final ModifiableColor quicksearchBackground = new ModifiableColor();

    public Object[] createApplicationSpecificKeysAndValues() {
        FlatLFCustoms.updateUnifiedBackground();
        Color editorContentBorderColor = UIManager.getColor("TabbedContainer.editor.contentBorderColor");
        Object[] removeCtrlPageUpDownKeyBindings = new Object[]{"ctrl PAGE_UP", null, "ctrl PAGE_DOWN", null};
        Object[] constants = new Object[]{"nb.options.categories.tabPanelBackground", unifiedBackground, "nb.quicksearch.background", quicksearchBackground, "TitlePane.useWindowDecorations", FlatLafPrefs.isUseWindowDecorations(), "TitlePane.unifiedBackground", FlatLafPrefs.isUnifiedTitleBar(), "TitlePane.menuBarEmbedded", FlatLafPrefs.isMenuBarEmbedded(), "MenuItem.selectionType", FlatLafPrefs.isUnderlineMenuSelection() ? "underline" : null, "Component.hideMnemonics", !FlatLafPrefs.isAlwaysShowMnemonics(), "controlFont", UIManager.getFont("Label.font"), "EditorTabDisplayerUI", "org.netbeans.swing.laf.flatlaf.ui.FlatEditorTabDisplayerUI", "ViewTabDisplayerUI", "org.netbeans.swing.laf.flatlaf.ui.FlatViewTabDisplayerUI", "SlidingButtonUI", "org.netbeans.swing.laf.flatlaf.ui.FlatSlidingButtonUI", "Nb.Editor.TabsComponent.border", BorderFactory.createEmptyBorder(), "Nb.Editor.Toolbar.border", new CompoundBorder(DPISafeBorder.matte(0, 0, 1, 0, editorContentBorderColor), BorderFactory.createEmptyBorder(1, 0, 1, 0)), "TabbedContainer.editor.contentBorder", DPISafeBorder.matte(0, 1, 1, 1, editorContentBorderColor), "TabbedContainer.view.contentBorder", DPISafeBorder.matte(0, 1, 1, 1, UIManager.getColor("TabbedContainer.view.contentBorderColor")), "Nb.SplitPane.dividerSize.vertical", UIScale.scale((int)4), "Nb.SplitPane.dividerSize.horizontal", UIScale.scale((int)4), "nb.close.tab.icon.enabled.icon", FlatTabControlIcon.get(1, 0), "nb.close.tab.icon.pressed.icon", FlatTabControlIcon.get(1, 1), "nb.close.tab.icon.rollover.icon", FlatTabControlIcon.get(1, 3), "nb.bigclose.tab.icon.enabled.icon", FlatTabControlIcon.get(1, 0), "nb.bigclose.tab.icon.pressed.icon", FlatTabControlIcon.get(1, 1), "nb.bigclose.tab.icon.rollover.icon", FlatTabControlIcon.get(1, 3), "nb.multitabs.button.dropdown.icon", FlatTabControlIcon.get(8), "nb.multitabs.button.maximize.icon", FlatTabControlIcon.get(3), "nb.multitabs.button.left.icon", FlatTabControlIcon.get(9), "nb.multitabs.button.right.icon", FlatTabControlIcon.get(10), "nb.multitabs.button.rollover", true, "nb.progress.cancel.icon", FlatTabControlIcon.get(1, 0), "nb.progress.cancel.icon.pressed", FlatTabControlIcon.get(1, 1), "nb.progress.cancel.icon.mouseover", FlatTabControlIcon.get(1, 3), "PropSheet.setBackground", new Color(UIManager.getColor("PropSheet.setBackground").getRGB()), "PropSheet.selectedSetBackground", new Color(UIManager.getColor("PropSheet.selectedSetBackground").getRGB()), "List.focusInputMap", new LazyModifyInputMap("List.focusInputMap", removeCtrlPageUpDownKeyBindings), "ScrollPane.ancestorInputMap", new LazyModifyInputMap("ScrollPane.ancestorInputMap", removeCtrlPageUpDownKeyBindings), "ScrollPane.ancestorInputMap.RightToLeft", new LazyModifyInputMap("ScrollPane.ancestorInputMap.RightToLeft", removeCtrlPageUpDownKeyBindings), "Table.ancestorInputMap", new LazyModifyInputMap("Table.ancestorInputMap", removeCtrlPageUpDownKeyBindings), "Table.ancestorInputMap.RightToLeft", new LazyModifyInputMap("Table.ancestorInputMap.RightToLeft", removeCtrlPageUpDownKeyBindings), "Tree.focusInputMap", new LazyModifyInputMap("Tree.focusInputMap", removeCtrlPageUpDownKeyBindings)};
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(Arrays.asList(constants));
        if (Utilities.isWindows()) {
            for (String key : new String[]{"Button", "RadioButton", "ToggleButton"}) {
                UIDefaults defaults = UIManager.getDefaults();
                Font font = defaults.getFont(key + ".font");
                Insets bm = defaults.getInsets(key + ".margin");
                if (font == null || !(bm instanceof InsetsUIResource) || !font.getFamily().equals("Segoe UI") || font.getSize() != 12 || bm.top != bm.bottom) continue;
                result.add(key + ".margin");
                result.add(new InsetsUIResource(bm.top, bm.left, bm.bottom + 1, bm.right));
            }
        }
        return result.toArray();
    }

    static void updateUnifiedBackground() {
        boolean unified = FlatLafPrefs.isUnifiedTitleBar() && FlatLafPrefs.isUseWindowDecorations();
        unifiedBackground.setRGB(UIManager.getColor(unified ? "Panel.background" : "Tree.background").getRGB());
        quicksearchBackground.setRGB(UIManager.getColor(unified ? "Panel.background" : "MenuBar.background").getRGB());
    }

    private static class LazyModifyInputMap
    implements UIDefaults.LazyValue {
        private final String baseKey;
        private final Object[] bindings;

        LazyModifyInputMap(String baseKey, Object[] bindings) {
            this.baseKey = baseKey;
            this.bindings = bindings;
        }

        @Override
        public Object createValue(UIDefaults table) {
            InputMap inputMap = (InputMap)UIManager.getLookAndFeelDefaults().get(this.baseKey);
            for (int i = 0; i < this.bindings.length; i += 2) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke((String)this.bindings[i]);
                if (this.bindings[i + 1] != null) {
                    inputMap.put(keyStroke, this.bindings[i + 1]);
                    continue;
                }
                inputMap.remove(keyStroke);
            }
            return inputMap;
        }
    }

    private static class ModifiableColor
    extends Color {
        private int rgb = super.getRGB();

        public ModifiableColor() {
            super(Color.red.getRGB());
        }

        @Override
        public int getRGB() {
            return this.rgb;
        }

        public void setRGB(int rgb) {
            this.rgb = rgb;
        }
    }
}

