/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import org.netbeans.modules.projectapi.LazyLookupProviders;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class LazyLookup
extends ProxyLookup {
    private final Map<String, Object> attrs;
    private final Lookup lkp;
    private Collection<String> serviceNames;
    final Thread[] LOCK = new Thread[]{null};

    public LazyLookup(Map<String, Object> attrs, Lookup lkp) {
        this.attrs = attrs;
        this.lkp = lkp;
        this.serviceNames = Arrays.asList(((String)attrs.get("service")).split(","));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeLookup(Lookup.Template<?> template) {
        LazyLookupProviders.safeToLoad(this.lkp);
        Class service = template.getType();
        class NotifyLater
        implements Executor {
            private List<Runnable> pending = new ArrayList<Runnable>();

            NotifyLater() {
            }

            @Override
            public void execute(Runnable command) {
                this.pending.add(command);
            }

            public void deliverPending() {
                List<Runnable> notify = this.pending;
                this.pending = null;
                for (Runnable r : notify) {
                    r.run();
                }
            }
        }
        NotifyLater later = null;
        Thread[] threadArray = this.LOCK;
        synchronized (this.LOCK) {
            while (true) {
                if (this.serviceNames == null || !this.serviceNames.contains(service.getName())) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                if (this.LOCK[0] == null) break;
                if (this.LOCK[0] == Thread.currentThread()) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                try {
                    this.LOCK.wait();
                }
                catch (InterruptedException ex) {
                    LazyLookupProviders.LOG.log(Level.INFO, null, ex);
                }
            }
            this.LOCK[0] = Thread.currentThread();
            this.LOCK.notifyAll();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            try {
                Thread[] instance = LazyLookupProviders.loadPSPInstance((String)this.attrs.get("class"), (String)this.attrs.get("method"), this.lkp);
                if (!service.isInstance(instance)) {
                    throw new ClassCastException("Instance of " + instance.getClass() + " unassignable to " + service);
                }
                later = new NotifyLater();
                this.setLookups(later, new Lookup[]{Lookups.singleton((Object)instance)});
                Thread[] threadArray2 = this.LOCK;
                synchronized (this.LOCK) {
                    this.serviceNames = null;
                    this.LOCK.notifyAll();
                    // ** MonitorExit[var5_8] (shouldn't be in output)
                }
            }
            catch (Exception x) {
                Exceptions.attachMessage((Throwable)x, (String)("while loading from " + this.attrs));
                Exceptions.printStackTrace((Throwable)x);
            }
            finally {
                Thread[] threadArray3 = this.LOCK;
                synchronized (this.LOCK) {
                    this.LOCK[0] = null;
                    this.LOCK.notifyAll();
                    // ** MonitorExit[var4_6] (shouldn't be in output)
                    if (later != null) {
                        later.deliverPending();
                    }
                }
            }
            {
                return;
            }
        }
    }

    boolean isInitializing() {
        return this.LOCK[0] != null;
    }

    public String toString() {
        return "LazyLookupProviders.LookupProvider[service=" + this.attrs.get("service") + ", class=" + this.attrs.get("class") + ", orig=" + this.attrs.get(FileObject.class) + "]";
    }
}

