/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.caret.CaretInfo;
import org.netbeans.api.editor.caret.EditorCaret;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.lib2.DocUtils;

public class TransposeLettersAction
extends BaseAction {
    private static final long serialVersionUID = 1L;

    public void actionPerformed(ActionEvent evt, final JTextComponent target) {
        if (target != null) {
            final Document doc = target.getDocument();
            DocUtils.runAtomicAsUser((Document)doc, (Runnable)new Runnable(){

                @Override
                public void run() {
                    Caret caret = target.getCaret();
                    if (caret instanceof EditorCaret) {
                        EditorCaret editorCaret = (EditorCaret)caret;
                        for (CaretInfo caretInfo : editorCaret.getSortedCarets()) {
                            if (DocUtils.transposeLetters((Document)doc, (int)caretInfo.getDot())) continue;
                            target.getToolkit().beep();
                        }
                    } else if (!DocUtils.transposeLetters((Document)doc, (int)target.getCaretPosition())) {
                        target.getToolkit().beep();
                    }
                }
            });
        }
    }
}

