/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.LookUpInterface;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleSetDTOWrapper;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRulesGroupDTOWrapper;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RuleSetNode;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RulesGroupNode;

public final class CreateGroupAction
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(CreateGroupAction.class.getName());
    private final RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private final LookUpInterface context;

    public CreateGroupAction(LookUpInterface context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (this.context instanceof ParsingRulesGroupDTOWrapper) {
            RulesGroupNode groupNode = (RulesGroupNode)Utilities.actionsGlobalContext().lookup(RulesGroupNode.class);
            if (groupNode != null) {
                ParsingRulesGroupDTOWrapper group = (ParsingRulesGroupDTOWrapper)this.context;
                if (group.getId() != null) {
                    this.model.addEmptyGroup(group.getId());
                    groupNode.updateChildren(group);
                } else {
                    LOGGER.log(Level.INFO, String.format("Group: %s [%s], parentId: %s", group.getName(), group.getId(), group.getParentId()));
                }
            }
        } else {
            RuleSetNode rulesetNode = (RuleSetNode)Utilities.actionsGlobalContext().lookup(RuleSetNode.class);
            if (rulesetNode != null) {
                ParsingRuleSetDTOWrapper ruleset = (ParsingRuleSetDTOWrapper)this.context;
                if (ruleset.getId() != null) {
                    this.model.addEmptyGroup(ruleset.getId());
                    rulesetNode.updateChildren(ruleset);
                } else {
                    LOGGER.log(Level.INFO, String.format("RuleSet: %s [%s]", ruleset.getName(), ruleset.getId()));
                }
            }
        }
    }
}

