/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.LookUpInterface;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleDTOWrapper;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRulesGroupDTOWrapper;
import rs.co.ast.aspen.gui.module.prseditor.ParsingRulesetEditorTopComponent;
import rs.co.ast.aspen.gui.module.prseditor.RuleDetailsPanel;
import rs.co.ast.aspen.gui.module.prseditor.RulesTableRenderer;
import rs.co.ast.aspen.gui.module.prseditor.TableColumnResizer;
import rs.co.ast.aspen.gui.module.prseditor.models.FocusRule;
import rs.co.ast.aspen.gui.module.prseditor.models.FocusRuleService;
import rs.co.ast.aspen.gui.module.prseditor.models.RulesTableModel;

public class RulesPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
LookupListener {
    private final Lookup.Result<LookUpInterface> lr = Utilities.actionsGlobalContext().lookupResult(LookUpInterface.class);
    private final Lookup.Result<FocusRule> result;
    private final FocusRuleService ruleService = (FocusRuleService)Lookup.getDefault().lookup(FocusRuleService.class);
    private RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private RulesTableModel tableModel = new RulesTableModel();
    private final ExplorerManager explorerManager = new ExplorerManager();
    private InstanceContent instanceContent = new InstanceContent();
    private final Lookup selectedRule = new AbstractLookup((AbstractLookup.Content)this.instanceContent);
    private RuleDetailsPanel ruleDetailsPanel;
    private ParsingRuleDTOWrapper prev;
    private ParsingRulesGroupDTOWrapper group;
    private int selectedRow = 0;
    private final Collection<? extends Action> ruleActions = Lookups.forPath((String)"RulePopupMenu/RightClickRule").lookupAll(Action.class);
    private final Collection<? extends Action> editModeActions = Lookups.forPath((String)"RulePopupMenu/EditMode").lookupAll(Action.class);
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JPopupMenu pmRule;
    private JTable tRules;

    public RulesPanel() {
        this.initComponents();
        this.addAncestorListener(new MyAncestorListener(this).getAncestorListener());
        this.initPopupMenus();
        this.result = this.ruleService.getLookup().lookupResult(FocusRule.class);
        this.result.addLookupListener((LookupListener)this);
        this.ruleDetailsPanel = new RuleDetailsPanel();
        this.jSplitPane1.setBottomComponent(this.ruleDetailsPanel);
        this.lr.allInstances();
        this.lr.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Lookup.Result lookupResult = (Lookup.Result)ev.getSource();
                Collection instances = lookupResult.allInstances();
                for (Object o : instances) {
                    if (o instanceof ParsingRulesGroupDTOWrapper) {
                        String pid = RulesPanel.this.group != null ? RulesPanel.this.group.getId() : "";
                        RulesPanel.this.group = (ParsingRulesGroupDTOWrapper)o;
                        if (!pid.equals(RulesPanel.this.group.getId())) {
                            RulesPanel.this.selectedRow = 0;
                        }
                        RulesPanel.this.tableModel.setGroup(RulesPanel.this.group);
                        if (RulesPanel.this.group.getRuleIds().isEmpty()) continue;
                        try {
                            RulesPanel.this.tRules.setRowSelectionInterval(RulesPanel.this.selectedRow, 0);
                            RulesPanel.this.tRules.changeSelection(RulesPanel.this.selectedRow, 0, false, false);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        continue;
                    }
                    RulesPanel.this.group = null;
                    RulesPanel.this.tableModel.setGroup(RulesPanel.this.group);
                    RulesPanel.this.ruleDetailsPanel.updateDisplay(null);
                }
            }
        });
        ActionListener deleteRuleLisener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RulesPanel.this.model.isEditMode()) {
                    ParsingRuleDTOWrapper rule = RulesPanel.this.tableModel.getRule(RulesPanel.this.selectedRow);
                    NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"DeleteRuleConfirmation.message"), NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"DeleteRuleConfirmation.title"), 0);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION && rule != null && RulesPanel.this.group != null) {
                        RulesPanel.this.model.removeRule(RulesPanel.this.group, rule);
                        if (RulesPanel.this.selectedRow > 0 && RulesPanel.this.selectedRow < RulesPanel.this.tableModel.getRowCount() - 1) {
                            --RulesPanel.this.selectedRow;
                        } else {
                            --RulesPanel.this.selectedRow;
                            if (RulesPanel.this.selectedRow < 0) {
                                ++RulesPanel.this.selectedRow;
                            }
                        }
                        if (RulesPanel.this.tableModel.getRowCount() != 0) {
                            RulesPanel.this.tRules.setRowSelectionInterval(RulesPanel.this.selectedRow, 0);
                            RulesPanel.this.tRules.changeSelection(RulesPanel.this.selectedRow, 0, false, false);
                        }
                    }
                }
            }
        };
        KeyStroke deleteStroke = KeyStroke.getKeyStroke(127, 2, false);
        this.tRules.registerKeyboardAction(deleteRuleLisener, deleteStroke, 0);
        ActionListener duplicateRuleLisener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParsingRuleDTOWrapper rule;
                if (RulesPanel.this.model.isEditMode() && (rule = RulesPanel.this.tableModel.getRule(RulesPanel.this.selectedRow)) != null && RulesPanel.this.group != null) {
                    RulesPanel.this.model.copyRule(RulesPanel.this.group, rule);
                }
            }
        };
        KeyStroke duplicateStroke = KeyStroke.getKeyStroke(68, 2, false);
        this.tRules.registerKeyboardAction(duplicateRuleLisener, duplicateStroke, 0);
        ActionListener toggleEditModeLisener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RulesPanel.this.model.toggleEditMode();
            }
        };
        KeyStroke toggleEditStroke = KeyStroke.getKeyStroke(69, 2, false);
        this.tRules.registerKeyboardAction(toggleEditModeLisener, toggleEditStroke, 0);
        ActionListener addRuleLisener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RulesPanel.this.model.isEditMode()) {
                    RulesPanel.this.model.addRule(RulesPanel.this.group.getId());
                }
            }
        };
        KeyStroke addStroke = KeyStroke.getKeyStroke(65, 2, false);
        this.tRules.registerKeyboardAction(addRuleLisener, addStroke, 0);
        ActionListener moveUpListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (RulesPanel.this.model.isEditMode()) {
                    ParsingRuleDTOWrapper rule = RulesPanel.this.tableModel.getRule(RulesPanel.this.selectedRow);
                    RulesPanel.this.model.moveUpRule(RulesPanel.this.group, rule);
                    if (RulesPanel.this.selectedRow - 1 >= 0) {
                        RulesPanel.this.tRules.setRowSelectionInterval(RulesPanel.this.selectedRow - 1, 0);
                        RulesPanel.this.tRules.changeSelection(RulesPanel.this.selectedRow - 1, 0, false, false);
                    }
                }
            }
        };
        KeyStroke strokeUp = KeyStroke.getKeyStroke(38, 2, false);
        this.tRules.registerKeyboardAction(moveUpListener, "MoveUp", strokeUp, 0);
        ActionListener moveDownListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (RulesPanel.this.model.isEditMode()) {
                    ParsingRuleDTOWrapper rule = RulesPanel.this.tableModel.getRule(RulesPanel.this.selectedRow);
                    RulesPanel.this.model.moveDownRule(RulesPanel.this.group, rule);
                    if (RulesPanel.this.selectedRow + 1 < RulesPanel.this.tableModel.getRowCount()) {
                        RulesPanel.this.tRules.setRowSelectionInterval(RulesPanel.this.selectedRow + 1, 0);
                        RulesPanel.this.tRules.changeSelection(RulesPanel.this.selectedRow + 1, 0, false, false);
                    }
                }
            }
        };
        KeyStroke strokeDown = KeyStroke.getKeyStroke(40, 2, false);
        this.tRules.registerKeyboardAction(moveDownListener, "MoveDown", strokeDown, 0);
        this.tRules.setDefaultRenderer(ParsingRuleDTOWrapper.class, new RulesTableRenderer());
        TableColumn descColumn = this.tRules.getColumnModel().getColumn(0);
        JTextField tfDesc = new JTextField();
        tfDesc.setBorder(BorderFactory.createEmptyBorder());
        descColumn.setCellEditor(new DefaultCellEditor(tfDesc));
        this.tRules.setFillsViewportHeight(true);
        this.tRules.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TableColumnResizer.adjustColumnPreferredWidths(RulesPanel.this.tRules);
            }
        });
        this.tRules.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && RulesPanel.this.tRules.getSelectedRowCount() == 1) {
                    RulesPanel.this.selectedRow = RulesPanel.this.tRules.getSelectedRow();
                    if (RulesPanel.this.prev != null) {
                        RulesPanel.this.instanceContent.remove((Object)RulesPanel.this.prev);
                    }
                    RulesPanel.this.prev = RulesPanel.this.tableModel.getRule(RulesPanel.this.tRules.getSelectedRow());
                    if (RulesPanel.this.prev != null) {
                        RulesPanel.this.instanceContent.add((Object)RulesPanel.this.prev);
                    }
                }
            }
        });
        this.tRules.addMouseListener(new MouseListener(){

            private void rightClick(MouseEvent e) {
                if (e.getButton() == 3) {
                    int row = RulesPanel.this.tRules.rowAtPoint(e.getPoint());
                    int column = RulesPanel.this.tRules.columnAtPoint(e.getPoint());
                    RulesPanel.this.selectedRow = RulesPanel.this.tRules.getSelectedRow();
                    if (!RulesPanel.this.tRules.isRowSelected(row)) {
                        if (row > -1) {
                            RulesPanel.this.tRules.setRowSelectionInterval(row, row);
                        }
                        RulesPanel.this.tRules.changeSelection(row, column, false, false);
                    }
                    RulesPanel.this.pmRule.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.rightClick(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.rightClick(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.rightClick(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("ancestor")) {
            switch (evt.getPropertyName()) {
                case "ruleAdded": 
                case "ruleRemoved": {
                    this.firePropertyChange("ruleChanged", "", evt.getNewValue());
                    break;
                }
                case "ruleChanged": {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RulesPanel.this.tableModel.fireTableDataChanged();
                        }
                    });
                    break;
                }
                case "editModeChanged": {
                    this.initPopupMenus();
                }
            }
        }
    }

    private void initPopupMenus() {
        this.pmRule.removeAll();
        ArrayList actions = new ArrayList();
        if (this.model.isEditMode()) {
            this.ruleActions.forEach(actions::add);
        }
        this.editModeActions.forEach(actions::add);
        this.pmRule = Utilities.actionsToPopup((Action[])actions.toArray(new Action[actions.size()]), (Component)this.tRules);
    }

    public RuleDetailsPanel getRuleDetailsPanel() {
        return this.ruleDetailsPanel;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public Lookup getSelectedRuleLookup() {
        return this.selectedRule;
    }

    public void updateDisplay() {
        if (this.group != null) {
            this.tableModel.setGroup(this.group);
        }
    }

    public void clearRulesDetailsPanel() {
        this.tableModel.setGroup(null);
        this.getRuleDetailsPanel().updateDisplay(null);
    }

    private void initComponents() {
        this.pmRule = new JPopupMenu();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.tRules = new JTable();
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setOrientation(0);
        this.tRules.setModel(this.tableModel);
        this.tRules.setComponentPopupMenu(this.pmRule);
        this.jScrollPane1.setViewportView(this.tRules);
        this.jSplitPane1.setTopComponent(this.jScrollPane1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 831, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 474, Short.MAX_VALUE).addContainerGap()));
    }

    public void resultChanged(LookupEvent ev) {
        Lookup.Result r = (Lookup.Result)ev.getSource();
        Collection instances = r.allInstances();
        for (Object o : instances) {
            FocusRule fr;
            int row;
            if (!(o instanceof FocusRule) || this.tRules.isRowSelected(row = this.tableModel.getRowForRule((fr = (FocusRule)o).getRule()))) continue;
            if (row > -1) {
                this.tRules.setRowSelectionInterval(row, row);
            } else {
                row = 0;
            }
            this.tRules.changeSelection(row, row, false, false);
        }
    }

    public class MyAncestorListener
    implements AncestorListener {
        private final RulesPanel panel;

        public MyAncestorListener(RulesPanel panel) {
            this.panel = panel;
        }

        public AncestorListener getAncestorListener() {
            return this;
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            RulesPanel.this.model.addPropertyChangeListener((PropertyChangeListener)this.panel);
            RulesPanel.this.ruleDetailsPanel.addPropertyChangeListener(this.panel);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            RulesPanel.this.model.removePropertyChangeListener((PropertyChangeListener)this.panel);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }
}

