/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.usermgmt;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ConsoleUser;
import rs.co.ast.aspen.api.service.PasswordPolicySettings;
import rs.co.ast.aspen.gui.module.usermgmt.ConsoleUserService;
import rs.co.ast.aspen.gui.module.usermgmt.PasswordPolicySettingsPanel;
import rs.co.ast.aspen.gui.module.usermgmt.PasswordPromptPanel;
import rs.co.ast.aspen.gui.module.usermgmt.UnlockConsoleUserAction;

public class UserDetailsPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(UserDetailsPanel.class.getName());
    private final Lookup.Result<ConsoleUser> lr = Utilities.actionsGlobalContext().lookupResult(ConsoleUser.class);
    private ConsoleUser originalData;
    private DialogDescriptor dd;
    private PasswordPromptPanel ppp;
    private static final DateTimeFormatter dtf = ISODateTimeFormat.basicDateTime();
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private ConsoleUser selectedUser = null;
    private JButton bReset;
    private JButton bSave;
    private JButton bUnlockUser;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JScrollPane jScrollPane1;
    private JButton passwordPolicySettings;
    private JTextArea taComment;
    private JTextField tfDisabled;
    private JTextField tfEmail;
    private JTextField tfLastLogin;
    private JTextField tfLastPasswordChange;
    private JTextField tfLocked;
    private JTextField tfUsername;

    public UserDetailsPanel() {
        this.initComponents();
        this.lr.allInstances();
        this.lr.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Lookup.Result lr = (Lookup.Result)ev.getSource();
                Collection instances = lr.allInstances();
                for (Object o : instances) {
                    ConsoleUser u;
                    if (!(o instanceof ConsoleUser)) continue;
                    UserDetailsPanel.this.selectedUser = u = (ConsoleUser)o;
                    UserDetailsPanel.this.originalData = u;
                    UserDetailsPanel.this.updateDisplay(u);
                }
            }
        });
        this.tfEmail.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                UserDetailsPanel.this.enableButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                UserDetailsPanel.this.enableButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                UserDetailsPanel.this.enableButtons();
            }
        });
        this.taComment.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                UserDetailsPanel.this.enableButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                UserDetailsPanel.this.enableButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                UserDetailsPanel.this.enableButtons();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.tfUsername = new JTextField();
        this.tfEmail = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.taComment = new JTextArea();
        this.bReset = new JButton();
        this.bSave = new JButton();
        this.tfLastLogin = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.tfLastPasswordChange = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel10 = new JLabel();
        this.passwordPolicySettings = new JButton();
        this.tfDisabled = new JTextField();
        this.tfLocked = new JTextField();
        this.bUnlockUser = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(UserDetailsPanel.class, (String)"UserDetailsPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(UserDetailsPanel.class, (String)"UserDetailsPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(UserDetailsPanel.class, (String)"UserDetailsPanel.jLabel3.text"));
        this.tfUsername.setEditable(false);
        this.tfUsername.setText(NbBundle.getMessage(UserDetailsPanel.class, (String)"UserDetailsPanel.tfUsername.text"));
        this.tfEmail.setText(NbBundle.getMessage(UserDetailsPanel.class, (String)"UserDetailsPanel.tfEmail.text"));
        this.taComment.setColumns(20);
        this.taComment.setRows(5);
        this.jScrollPane1.setViewportView(this.taComment);
        Mnemonics.setLocalizedText((AbstractButton)this.bReset, (String)NbBundle.getMessage(UserDetailsPanel.class, (String)"UserDetailsPanel.bReset.text"));
        this.bReset.setEnabled(false);
        this.bReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserDetailsPanel.this.bResetActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bSave, (String)NbBundle.getMessage(UserDetailsPanel.class, (String)"UserDetailsPanel.bSave.text"));
        this.bSave.setEnabled(false);
        this.bSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserDetailsPanel.this.bSaveActionPerformed(evt);
            }
        });
        this.tfLastLogin.setEditable(false);
        this.tfLastLogin.setText(NbBundle.getMessage(UserDetailsPanel.class, (String)"UserDetailsPanel.tfLastLogin.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(UserDetailsPanel.class, (String)"UserDetailsPanel.jLabel5.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(UserDetailsPanel.class, (String)"UserDetailsPanel.jLabel6.text"));
        this.tfLastPasswordChange.setEditable(false);
        this.tfLastPasswordChange.setText(NbBundle.getMessage(UserDetailsPanel.class, (String)"UserDetailsPanel.tfLastPasswordChange.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(UserDetailsPanel.class, (String)"UserDetailsPanel.jLabel8.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(UserDetailsPanel.class, (String)"UserDetailsPanel.jLabel10.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.passwordPolicySettings, (String)NbBundle.getMessage(UserDetailsPanel.class, (String)"UserDetailsPanel.passwordPolicySettings.text"));
        this.passwordPolicySettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserDetailsPanel.this.passwordPolicySettingsActionPerformed(evt);
            }
        });
        this.tfDisabled.setEditable(false);
        this.tfDisabled.setText(NbBundle.getMessage(UserDetailsPanel.class, (String)"UserDetailsPanel.tfDisabled.text"));
        this.tfLocked.setEditable(false);
        this.tfLocked.setText(NbBundle.getMessage(UserDetailsPanel.class, (String)"UserDetailsPanel.tfLocked.text"));
        this.bUnlockUser.setIcon(new ImageIcon(this.getClass().getResource("/rs/co/ast/aspen/gui/module/usermgmt/unlock.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bUnlockUser, (String)NbBundle.getMessage(UserDetailsPanel.class, (String)"UserDetailsPanel.bUnlockUser.text"));
        this.bUnlockUser.setToolTipText(NbBundle.getMessage(UserDetailsPanel.class, (String)"UserDetailsPanel.bUnlockUser.toolTipText"));
        this.bUnlockUser.setEnabled(false);
        this.bUnlockUser.setMargin(new Insets(2, 10, 2, 10));
        this.bUnlockUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserDetailsPanel.this.bUnlockUserActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING)).addGap(30, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 270, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel8, -2, 161, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfDisabled, -2, 221, -2).addComponent(this.tfLocked, -2, 221, -2))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.bUnlockUser)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.tfUsername, -2, 270, -2).addGap(18, 18, 18).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.tfEmail, -2, 270, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel6))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfLastLogin, GroupLayout.Alignment.TRAILING, -2, 221, -2).addComponent(this.tfLastPasswordChange, -2, 221, -2))))).addGroup(layout.createSequentialGroup().addComponent(this.bReset).addGap(18, 18, 18).addComponent(this.bSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.passwordPolicySettings))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.tfUsername, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.tfLastLogin, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.tfEmail, -2, -1, -2).addComponent(this.jLabel6, -2, -1, -2).addComponent(this.tfLastPasswordChange, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jScrollPane1, -2, 94, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.tfDisabled, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel10).addComponent(this.tfLocked, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bUnlockUser))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bReset).addComponent(this.bSave).addComponent(this.passwordPolicySettings)).addContainerGap()));
    }

    private void bResetActionPerformed(ActionEvent evt) {
        this.updateDisplay(this.originalData);
    }

    private void bSaveActionPerformed(ActionEvent evt) {
        try {
            this.originalData.setEmail(this.tfEmail.getText());
            this.originalData.setComment(this.taComment.getText());
            ConsoleUserService cus = (ConsoleUserService)Lookup.getDefault().lookup(ConsoleUserService.class);
            cus.updateData(this.originalData);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(UserDetailsPanel.class, (String)"user_details_saved.text")));
            this.disableButtons();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void passwordPolicySettingsActionPerformed(ActionEvent evt) {
        PasswordPolicySettings pps = null;
        try {
            pps = this.apiService.getPasswordPolicySettings();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (pps != null) {
            final PasswordPolicySettingsPanel ppsp = new PasswordPolicySettingsPanel(pps);
            this.dd = new DialogDescriptor((Object)ppsp, NbBundle.getMessage(UserDetailsPanel.class, (String)"user_details.passwordPolicySettings"), true, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int opt = (Integer)e.getSource();
                    if (DialogDescriptor.OK_OPTION.equals(opt)) {
                        PasswordPolicySettings newPps = ppsp.getPasswordPolicySettings();
                        try {
                            UserDetailsPanel.this.apiService.setPasswordPolicySettings(newPps);
                        }
                        catch (ApiServiceException_Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            });
            DialogDisplayer.getDefault().createDialog(this.dd).setVisible(true);
        }
    }

    private void bUnlockUserActionPerformed(ActionEvent evt) {
        if (this.selectedUser != null) {
            this.bUnlockUser.setEnabled(false);
            UnlockConsoleUserAction ucua = new UnlockConsoleUserAction(this.selectedUser);
            ucua.actionPerformed(evt);
        }
    }

    private void updateDisplay(final ConsoleUser u) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UserDetailsPanel.this.tfUsername.setText(u.getId());
                UserDetailsPanel.this.tfEmail.setText(u.getEmail());
                UserDetailsPanel.this.taComment.setText(u.getComment());
                UserDetailsPanel.this.tfDisabled.setText(String.valueOf(u.isDisabled()));
                UserDetailsPanel.this.tfLocked.setText(String.valueOf(u.isLocked()));
                UserDetailsPanel.this.tfLastLogin.setText(dtf.print(u.getLastLogin()));
                UserDetailsPanel.this.tfLastPasswordChange.setText(dtf.print(u.getLastPasswordChange()));
                UserDetailsPanel.this.bUnlockUser.setEnabled(u.isLocked());
                UserDetailsPanel.this.disableButtons();
            }
        });
    }

    private void enableButtons() {
        this.bSave.setEnabled(true);
        this.bReset.setEnabled(true);
    }

    private void disableButtons() {
        this.bSave.setEnabled(false);
        this.bReset.setEnabled(false);
    }

    private void changePassword(String password) {
        try {
            ConsoleUserService cus = (ConsoleUserService)Lookup.getDefault().lookup(ConsoleUserService.class);
            cus.changePassword(this.originalData.getId(), password);
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

