/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.filesystems.spi.ArchiveRootProvider;
import org.openide.util.Exceptions;

final class JarArchiveRootProvider
implements ArchiveRootProvider {
    private static final String PROTOCOL = "jar";
    private static byte[] ZIP_HEADER_1 = new byte[]{80, 75, 3, 4};
    private static byte[] ZIP_HEADER_2 = new byte[]{80, 75, 5, 6};
    private static final Logger LOG = Logger.getLogger(JarArchiveRootProvider.class.getName());
    private static final Map<FileObject, Boolean> archiveFileCache = Collections.synchronizedMap(new WeakHashMap());
    private static final Set<String> KNOWN_ZIP_EXTENSIONS = new HashSet<String>(Arrays.asList("jar", "war", "zip", "ear", "sar", "rar"));

    JarArchiveRootProvider() {
    }

    @Override
    public boolean isArchiveFile(URL url, boolean strict) {
        if (PROTOCOL.equals(url.getProtocol())) {
            return false;
        }
        FileObject fo = URLMapper.findFileObject(url);
        if (fo != null && !fo.isVirtual()) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "isArchiveFile_FILE_RESOLVED", fo);
            }
            return this.isArchiveFile(fo, strict);
        }
        return JarArchiveRootProvider.isArchiveFile(url.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isArchiveFile(FileObject fo, boolean strict) {
        if (!fo.isValid()) {
            return JarArchiveRootProvider.isArchiveFile(fo.getPath());
        }
        if (fo.isVirtual()) {
            return JarArchiveRootProvider.isArchiveFile(fo.getPath());
        }
        if (fo.isFolder()) {
            return false;
        }
        Boolean b = archiveFileCache.get(fo);
        if (b != null) return b;
        try (InputStream in = fo.getInputStream();){
            byte[] buffer = new byte[4];
            int len = in.read(buffer, 0, 4);
            if (len != 4) {
                boolean bl = !strict;
                return bl;
            }
            b = Arrays.equals(ZIP_HEADER_1, buffer) || Arrays.equals(ZIP_HEADER_2, buffer);
        }
        catch (IOException ioe) {
            LOG.log(Level.FINE, null, ioe);
        }
        if (b == null) {
            b = JarArchiveRootProvider.isArchiveFile(fo.getPath());
        }
        archiveFileCache.put(fo, b);
        return b;
    }

    @Override
    public boolean isArchiveArtifact(URL url) {
        return PROTOCOL.equals(url.getProtocol());
    }

    @Override
    public URL getArchiveFile(URL url) {
        String path;
        int index;
        String protocol = url.getProtocol();
        if (PROTOCOL.equals(protocol) && (index = (path = url.getPath()).indexOf("!/")) >= 0) {
            String jarPath = null;
            try {
                jarPath = path.substring(0, index);
                if (jarPath.indexOf("file://") > -1 && jarPath.indexOf("file:////") == -1) {
                    jarPath = jarPath.replaceFirst("file://", "file:////");
                }
                return new URL(jarPath);
            }
            catch (MalformedURLException mue) {
                LOG.log(Level.WARNING, "Invalid URL ({0}): {1}, jarPath: {2}", new Object[]{mue.getMessage(), url.toExternalForm(), jarPath});
            }
        }
        return null;
    }

    @Override
    public FileObject getArchiveFile(FileObject fo) {
        try {
            FileSystem fs = fo.getFileSystem();
            if (fs instanceof JarFileSystem) {
                File jarFile = ((JarFileSystem)fs).getJarFile();
                return FileUtil.toFileObject(jarFile);
            }
        }
        catch (FileStateInvalidException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    @Override
    public URL getArchiveRoot(URL url) {
        try {
            return new URL("jar:" + url + "!/");
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static boolean isArchiveFile(String path) {
        int dot = path.lastIndexOf(46);
        int slash = path.lastIndexOf(47);
        return dot != -1 && dot > slash + 1 && KNOWN_ZIP_EXTENSIONS.contains(path.substring(dot + 1));
    }
}

