/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.text.Line;
import org.openide.util.BaseUtilities;

final class LineVector {
    private static final Logger LOG = Logger.getLogger(LineVector.class.getName());
    private Ref[] refArray;
    private int gapStart;
    private int gapLength;
    private int disposedRefCount;
    private boolean refArrayUnsorted;
    private Thread lockThread;
    private int lockDepth;
    private List<LineUpdater> pendingLineUpdaters = new ArrayList<LineUpdater>(2);

    LineVector() {
        this.refArray = new Ref[4];
        this.gapLength = this.refArray.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Line findOrCreateLine(int findLineIndex, LineCreator lineCreator) {
        this.lockCheckUpdate();
        try {
            int last = this.refCount() - 1;
            int low = 0;
            int high = last;
            if (!this.refArrayUnsorted) {
                int lowLineIndex = -1;
                int highLineIndex = Integer.MAX_VALUE;
                while (low <= high) {
                    int lineIndex;
                    int mid = low + high >>> 1;
                    Ref ref = this.refArray[this.rawIndex(mid)];
                    Line line = (Line)ref.get();
                    if (line == null) {
                        for (int index = mid - 1; index >= 0 && (line = (Line)(ref = this.refArray[this.rawIndex(index)]).get()) == null; --index) {
                        }
                    }
                    int n = lineIndex = line != null ? line.getLineNumber() : -1;
                    if (lineIndex < lowLineIndex || lineIndex > highLineIndex) {
                        if (LOG.isLoggable(Level.FINE)) {
                            String msg = "!!!LineVector: ARRAY BECAME UNSORTED!!!\n  " + this.toStringDetail() + "    lineIndex=" + lineIndex + ", lowLineIndex=" + lowLineIndex + ", highLineIndex=" + highLineIndex + "\n    low=" + low + ", high=" + high + ", mid=" + mid + "\n";
                            LOG.log(Level.INFO, msg, new Throwable());
                        }
                        this.refArrayUnsorted = true;
                        break;
                    }
                    if (lineIndex < findLineIndex) {
                        low = mid + 1;
                        lowLineIndex = lineIndex;
                        continue;
                    }
                    if (lineIndex > findLineIndex) {
                        high = mid - 1;
                        highLineIndex = lineIndex;
                        continue;
                    }
                    Line line2 = line;
                    return line2;
                }
            }
            if (this.refArrayUnsorted) {
                while (low <= last) {
                    Ref ref = this.refArray[this.rawIndex(low)];
                    Line line = (Line)ref.get();
                    if (line != null && line.getLineNumber() == findLineIndex) {
                        Line line3 = line;
                        return line3;
                    }
                    ++low;
                }
                low = this.gapStart;
            }
            Line line = lineCreator != null ? this.addLine(low, lineCreator.createLine(findLineIndex)) : null;
            return line;
        }
        finally {
            this.unlockCheckUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLines(LineUpdater lineUpdater) {
        LineVector lineVector = this;
        synchronized (lineVector) {
            this.pendingLineUpdaters.add(lineUpdater);
            if (this.lockThread == null) {
                this.lockCheckUpdate();
                this.unlockCheckUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLinesCheck() {
        ArrayList<LineUpdater> lineUpdaters;
        LineVector lineVector = this;
        synchronized (lineVector) {
            if (this.pendingLineUpdaters.size() > 0) {
                lineUpdaters = new ArrayList<LineUpdater>(this.pendingLineUpdaters);
                this.pendingLineUpdaters.clear();
            } else {
                lineUpdaters = null;
            }
        }
        if (lineUpdaters != null) {
            for (LineUpdater lineUpdater : lineUpdaters) {
                Line line;
                int rawIndex;
                for (rawIndex = 0; rawIndex < this.gapStart; ++rawIndex) {
                    line = (Line)this.refArray[rawIndex].get();
                    lineUpdater.updateLine(line);
                }
                for (rawIndex = this.gapStart + this.gapLength; rawIndex < this.refArray.length; ++rawIndex) {
                    line = (Line)this.refArray[rawIndex].get();
                    lineUpdater.updateLine(line);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Line> getLinesInRange(int startLineIndex, int endLineIndex) {
        this.lockCheckUpdate();
        try {
            ArrayList<Line> lines = new ArrayList<Line>();
            int last = this.refCount() - 1;
            int low = 0;
            int high = last;
            if (!this.refArrayUnsorted) {
                int lowLineIndex = -1;
                int highLineIndex = Integer.MAX_VALUE;
                while (low <= high) {
                    int lineIndex;
                    int mid = low + high >>> 1;
                    Ref ref = this.refArray[this.rawIndex(mid)];
                    Line line = (Line)ref.get();
                    if (line == null) {
                        for (int index = mid - 1; index >= 0 && (line = (Line)(ref = this.refArray[this.rawIndex(index)]).get()) == null; --index) {
                        }
                    }
                    int n = lineIndex = line != null ? line.getLineNumber() : -1;
                    if (lineIndex < lowLineIndex || lineIndex > highLineIndex) {
                        this.refArrayUnsorted = true;
                        if (!LOG.isLoggable(Level.FINE)) break;
                        String msg = "!!!LineVector: ARRAY BECAME UNSORTED!!!\n  " + this.toStringDetail() + "    lineIndex=" + lineIndex + ", lowLineIndex=" + lowLineIndex + ", highLineIndex=" + highLineIndex + "\n    low=" + low + ", high=" + high + ", mid=" + mid + "\n";
                        LOG.log(Level.INFO, msg, new Throwable());
                        break;
                    }
                    if (lineIndex < startLineIndex) {
                        low = mid + 1;
                        lowLineIndex = lineIndex;
                        continue;
                    }
                    if (lineIndex > startLineIndex) {
                        high = mid - 1;
                        highLineIndex = lineIndex;
                        continue;
                    }
                    while (--mid >= 0 && ((line = (Line)(ref = this.refArray[this.rawIndex(mid)]).get()) == null || line.getLineNumber() >= startLineIndex)) {
                    }
                    low = mid + 1;
                    break;
                }
                if (!this.refArrayUnsorted) {
                    while (low <= last) {
                        Line line = (Line)this.refArray[this.rawIndex(low)].get();
                        if (line != null) {
                            int lineIndex = line.getLineNumber();
                            if (startLineIndex > lineIndex || lineIndex > endLineIndex) break;
                            lines.add(line);
                        }
                        ++low;
                    }
                }
            }
            if (this.refArrayUnsorted) {
                while (low <= last) {
                    int lineIndex;
                    Line line = (Line)this.refArray[this.rawIndex(low)].get();
                    if (line != null && startLineIndex <= (lineIndex = line.getLineNumber()) && lineIndex <= endLineIndex) {
                        lines.add(line);
                    }
                    ++low;
                }
            }
            ArrayList<Line> arrayList = lines;
            return arrayList;
        }
        finally {
            this.unlockCheckUpdate();
        }
    }

    private Line addLine(int index, Line line) {
        this.moveGap(index);
        if (this.gapLength == 0) {
            this.reallocate(this.refArray.length + 8 >> 2);
        }
        this.refArray[this.gapStart++] = new Ref(line);
        --this.gapLength;
        return line;
    }

    private int refCount() {
        return this.refArray.length - this.gapLength;
    }

    private int rawIndex(int index) {
        return index < this.gapStart ? index : index + this.gapLength;
    }

    private void moveGap(int index) {
        if (index <= this.gapStart) {
            int moveSize = this.gapStart - index;
            System.arraycopy(this.refArray, index, this.refArray, this.gapStart + this.gapLength - moveSize, moveSize);
        } else {
            int moveSize = index - this.gapStart;
            System.arraycopy(this.refArray, this.gapStart + this.gapLength, this.refArray, this.gapStart, moveSize);
        }
        this.gapStart = index;
    }

    synchronized void refGC() {
        ++this.disposedRefCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRemoveEmptyRefs() {
        int cnt;
        LineVector lineVector = this;
        synchronized (lineVector) {
            cnt = this.disposedRefCount;
        }
        if (cnt > 4 && cnt > this.refCount() >>> 3) {
            this.removeEmptyRefs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEmptyRefs() {
        int newGapLength;
        int rawIndex;
        int validIndex = 0;
        int emptyCount = 0;
        int gapEnd = this.gapStart + this.gapLength;
        for (rawIndex = 0; rawIndex < this.gapStart; ++rawIndex) {
            Ref ref = this.refArray[rawIndex];
            if (ref.get() != null) {
                if (rawIndex != validIndex) {
                    this.refArray[validIndex] = ref;
                }
                ++validIndex;
                continue;
            }
            ++emptyCount;
        }
        this.gapStart = validIndex;
        int topValidIndex = rawIndex = this.refArray.length;
        while (--rawIndex >= gapEnd) {
            Ref ref = this.refArray[rawIndex];
            if (ref.get() != null) {
                if (rawIndex == --topValidIndex) continue;
                this.refArray[topValidIndex] = ref;
                continue;
            }
            ++emptyCount;
        }
        this.gapLength = newGapLength = topValidIndex - this.gapStart;
        while (validIndex < topValidIndex) {
            this.refArray[validIndex++] = null;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("LineVector.removeDisposedRefsLockAcquired() refCount=" + this.refCount() + ", emptyCount=" + emptyCount + "\n");
        }
        LineVector lineVector = this;
        synchronized (lineVector) {
            this.disposedRefCount -= emptyCount;
        }
    }

    private void reallocate(int newGapLength) {
        int gapEnd = this.gapStart + this.gapLength;
        int aboveGapLength = this.refArray.length - gapEnd;
        int newLength = this.gapStart + aboveGapLength + newGapLength;
        Ref[] newRefArray = new Ref[newLength];
        System.arraycopy(this.refArray, 0, newRefArray, 0, this.gapStart);
        System.arraycopy(this.refArray, gapEnd, newRefArray, newLength - aboveGapLength, aboveGapLength);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("LineVector.reallocate() from refArray.length=" + this.refArray.length + " to newLength=" + newLength + "\n");
        }
        this.gapLength = newGapLength;
        this.refArray = newRefArray;
    }

    private void lockCheckUpdate() {
        this.lock();
        this.checkRemoveEmptyRefs();
    }

    private synchronized void lock() {
        Thread currentThread = Thread.currentThread();
        while (this.lockThread != null && currentThread != this.lockThread) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new Error("Interrupted attempt to aquire lock");
            }
        }
        if (this.lockThread != null) {
            throw new IllegalStateException("Recursive line vector locking prohibited. LineVector: " + this);
        }
        this.lockThread = currentThread;
        ++this.lockDepth;
    }

    private void unlockCheckUpdate() {
        this.updateLinesCheck();
        this.unlock();
    }

    private synchronized void unlock() {
        --this.lockDepth;
        if (this.lockDepth == 0) {
            this.lockThread = null;
            this.notifyAll();
        }
    }

    public String toString() {
        return "refArray.length=" + this.refArray.length + ", gapStart=" + this.gapStart + ", gapLength=" + this.gapLength + ", disposedRefCount=" + this.disposedRefCount + ", activeRefCount=" + (this.refCount() - this.disposedRefCount) + "\n  refArrayUnsorted=" + this.refArrayUnsorted + ", lockThread=" + this.lockThread + ", lockDepth=" + this.lockDepth + ", pendingLineUpdaters=" + this.pendingLineUpdaters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toStringDetail() {
        StringBuilder sb = new StringBuilder(256);
        this.lock();
        try {
            sb.append(this.toString()).append('\n');
            for (int i = 0; i < this.refCount(); ++i) {
                Ref ref = this.refArray[this.rawIndex(i)];
                Line line = (Line)ref.get();
                sb.append("[").append(i).append("]:\t").append(line).append('\n');
            }
        }
        finally {
            this.unlock();
        }
        return sb.toString();
    }

    static interface LineUpdater {
        public void updateLine(Line var1);
    }

    static interface LineCreator {
        public Line createLine(int var1);
    }

    private final class Ref
    extends WeakReference<Line>
    implements Runnable {
        public Ref(Line line) {
            super(line, BaseUtilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            LineVector.this.refGC();
        }
    }
}

