/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.openide.explorer.ExplorerManager;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleSetDTOWrapper;
import rs.co.ast.aspen.gui.module.prseditor.PRSTreeExplorerManager;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RootNode;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RuleSetNode;

public final class CopyRuleSetAction
implements ActionListener {
    private final RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private final ParsingRuleSetDTOWrapper ruleSet;

    public CopyRuleSetAction(ParsingRuleSetDTOWrapper ruleSet) {
        this.ruleSet = ruleSet;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        RuleSetNode ruleSetNode = (RuleSetNode)Utilities.actionsGlobalContext().lookup(RuleSetNode.class);
        if (ruleSetNode != null) {
            try {
                this.model.duplicateRuleSet(this.ruleSet);
                ExplorerManager explorerManager = PRSTreeExplorerManager.getMainPRSTreeExplorerManager();
                if (explorerManager != null) {
                    RootNode rootNode = (RootNode)explorerManager.getRootContext();
                    rootNode.updateChildren();
                }
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

