/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.SecurityEvent;

public class AlertEventDetailsTableModel
extends DefaultTableModel {
    private List<Item> data = new ArrayList<Item>();

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Item.class;
    }

    public List<Item> getData() {
        return this.data;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return NbBundle.getMessage(AlertEventDetailsTableModel.class, (String)"AlertEventsDetailsTableModel.table.col0.title");
            }
            case 1: {
                return NbBundle.getMessage(AlertEventDetailsTableModel.class, (String)"AlertEventsDetailsTableModel.table.col1.title");
            }
        }
        throw new IllegalArgumentException("Invalid column index");
    }

    public void setEvent(SecurityEvent event) {
        this.data.clear();
        if (event != null) {
            this.data.add(new Item("", "id", event.getId()));
            String whatTitle = NbBundle.getMessage(AlertEventDetailsTableModel.class, (String)"AlertEventsDetailsTableModel.what.title");
            this.data.add(new Item(whatTitle, null, null));
            if (event.getWhat() != null) {
                Collections.sort(event.getWhat().getEntry(), (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getKey(), o2.getKey()));
                event.getWhat().getEntry().forEach(e -> this.data.add(new Item(whatTitle, e.getKey(), e.getValue())));
            }
            String whoTitle = NbBundle.getMessage(AlertEventDetailsTableModel.class, (String)"AlertEventsDetailsTableModel.who.title");
            this.data.add(new Item(whoTitle, null, null));
            if (event.getWho() != null) {
                Collections.sort(event.getWho().getEntry(), (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getKey(), o2.getKey()));
                event.getWho().getEntry().forEach(e -> this.data.add(new Item(whoTitle, e.getKey(), e.getValue())));
            }
            String whereTitle = NbBundle.getMessage(AlertEventDetailsTableModel.class, (String)"AlertEventsDetailsTableModel.where.title");
            this.data.add(new Item(whereTitle, null, null));
            if (event.getWhere() != null) {
                Collections.sort(event.getWhere().getEntry(), (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getKey(), o2.getKey()));
                event.getWhere().getEntry().forEach(e -> this.data.add(new Item(whereTitle, e.getKey(), e.getValue())));
            }
            String whenTitle = NbBundle.getMessage(AlertEventDetailsTableModel.class, (String)"AlertEventsDetailsTableModel.when.title");
            this.data.add(new Item(whenTitle, null, null));
            if (event.getWhen() != null) {
                Collections.sort(event.getWhen().getEntry(), (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getKey(), o2.getKey()));
                event.getWhen().getEntry().forEach(e -> this.data.add(new Item(whenTitle, e.getKey(), e.getValue())));
            }
            String extraTitle = NbBundle.getMessage(AlertEventDetailsTableModel.class, (String)"AlertEventsDetailsTableModel.extra.title");
            this.data.add(new Item(extraTitle, null, null));
            if (event.getExtra() != null) {
                Collections.sort(event.getExtra().getEntry(), (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getKey(), o2.getKey()));
                event.getExtra().getEntry().forEach(e -> this.data.add(new Item(extraTitle, e.getKey(), e.getValue())));
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.data != null ? this.data.size() : 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.data != null && rowIndex >= 0 && rowIndex < this.data.size()) {
            return this.data.get(rowIndex);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public static class Item {
        public String category;
        public String key;
        public String value;

        public Item(String category, String key, String value) {
            this.category = category;
            this.key = key;
            this.value = value;
        }

        public String getCategory() {
            return this.category;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

