/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.sourcestatistics;

import java.awt.datatransfer.Transferable;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.plaf.basic.core.BasicTransferable;

public class TableTransferHandlerColumnOne
extends TransferHandler
implements UIResource {
    private NumberFormat nf = NumberFormat.getNumberInstance(Locale.getDefault());

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof JTable) {
            int[] cols;
            int counter;
            int[] rows;
            JTable table = (JTable)c;
            if (!table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed()) {
                return null;
            }
            if (!table.getRowSelectionAllowed()) {
                int rowCount = table.getRowCount();
                rows = new int[rowCount];
                for (counter = 0; counter < rowCount; ++counter) {
                    rows[counter] = counter;
                }
            } else {
                rows = table.getSelectedRows();
            }
            if (!table.getColumnSelectionAllowed()) {
                int colCount = table.getColumnCount();
                cols = new int[colCount];
                for (counter = 0; counter < colCount; ++counter) {
                    cols[counter] = counter;
                }
            } else {
                cols = table.getSelectedColumns();
            }
            if (rows == null || cols == null || rows.length == 0 || cols.length == 0) {
                return null;
            }
            StringBuilder plainBuf = new StringBuilder();
            StringBuilder htmlBuf = new StringBuilder();
            htmlBuf.append("<html>\n<body>\n<table>\n");
            if (table.getRowCount() == rows.length || table.getColumnCount() == cols.length) {
                htmlBuf.append("<tr>\n");
                for (int i = 0; i < cols.length; ++i) {
                    plainBuf.append(table.getColumnName(cols[i])).append("\t");
                    htmlBuf.append("  <td>").append(table.getColumnName(i)).append("</td>\n");
                }
                plainBuf.deleteCharAt(plainBuf.length() - 1).append("\n");
                htmlBuf.append("</tr>\n");
            }
            for (int row = 0; row < rows.length; ++row) {
                htmlBuf.append("<tr>\n");
                for (int col = 0; col < cols.length; ++col) {
                    Object obj = null;
                    obj = cols[col] == 1 ? this.nf.format((Long)table.getValueAt(rows[row], cols[col])) : table.getValueAt(rows[row], cols[col]);
                    String val = obj == null ? "" : obj.toString();
                    plainBuf.append(val + "\t");
                    htmlBuf.append("  <td>").append(val).append("</td>\n");
                }
                plainBuf.deleteCharAt(plainBuf.length() - 1).append("\n");
                htmlBuf.append("</tr>\n");
            }
            plainBuf.deleteCharAt(plainBuf.length() - 1);
            htmlBuf.append("</table>\n</body>\n</html>");
            return new BasicTransferable(plainBuf.toString(), htmlBuf.toString());
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }
}

