/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.sourcestatistics;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.HostStatsAgg;

public class SumOfCountsPerHostnameTableModelV2
extends DefaultTableModel {
    private final List<String> columns = Stream.of(NbBundle.getMessage(SumOfCountsPerHostnameTableModelV2.class, (String)"SumOfCountsPerHostnameTableModel.columnName.host"), NbBundle.getMessage(SumOfCountsPerHostnameTableModelV2.class, (String)"SumOfCountsPerHostnameTableModel.columnName.domains"), NbBundle.getMessage(SumOfCountsPerHostnameTableModelV2.class, (String)"SumOfCountsPerHostnameTableModel.columnName.fqdns"), NbBundle.getMessage(SumOfCountsPerHostnameTableModelV2.class, (String)"SumOfCountsPerHostnameTableModel.columnName.tags"), NbBundle.getMessage(SumOfCountsPerHostnameTableModelV2.class, (String)"SumOfCountsPerHostnameTableModel.columnName.ips"), NbBundle.getMessage(SumOfCountsPerHostnameTableModelV2.class, (String)"SumOfCountsPerHostnameTableModel.columnName.numberOfEvents"), NbBundle.getMessage(SumOfCountsPerHostnameTableModelV2.class, (String)"SumOfCountsPerHostnameTableModel.columnName.firstActive"), NbBundle.getMessage(SumOfCountsPerHostnameTableModelV2.class, (String)"SumOfCountsPerHostnameTableModel.columnName.lastActive")).collect(Collectors.toList());
    private List<HostStatsAgg> data = new ArrayList<HostStatsAgg>();
    private NumberFormat nf = NumberFormat.getNumberInstance(Locale.getDefault());

    @Override
    public Object getValueAt(int row, int column) {
        HostStatsAgg element = this.data.get(row);
        switch (this.columns.get(column)) {
            case "Hosts": {
                return element.getHost();
            }
            case "Domains": {
                return element.getDomains().stream().collect(Collectors.joining(";"));
            }
            case "Fqdns": {
                return element.getFqdns().stream().collect(Collectors.joining(";"));
            }
            case "Tags": {
                return element.getTags().stream().distinct().collect(Collectors.joining(";"));
            }
            case "Ips": {
                return element.getIps().stream().collect(Collectors.joining(";"));
            }
            case "NumberOfEvents": {
                return element.getSum();
            }
            case "FirstActive": {
                return element.getHumanFirstActive();
            }
            case "LastActive": {
                return element.getHumanLastActive();
            }
        }
        throw new IllegalArgumentException(NbBundle.getMessage(SumOfCountsPerHostnameTableModelV2.class, (String)"TableModel.columnName.unknown"));
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get(column);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return Long.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return String.class;
            }
        }
        throw new IllegalArgumentException(NbBundle.getMessage(SumOfCountsPerHostnameTableModelV2.class, (String)"TableModel.columnName.unknown"));
    }

    public void update(List<HostStatsAgg> data) {
        this.data = data;
        this.fireTableDataChanged();
    }

    public List<HostStatsAgg> getData() {
        return this.data;
    }
}

