/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.sourcestatistics;

import com.github.zafarkhaja.semver.Version;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.calendar.SingleDaySelectionModel;
import org.jdesktop.swingx.painter.BusyPainter;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.EnrichedHostStatsGuiReport;
import rs.co.ast.aspen.api.service.HostStatsCsvReport;
import rs.co.ast.aspen.gui.module.datamaps.TableTransferHandler;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.ComplementInfoPanel;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.ComplementTableModel;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.ComplementTableRenderer;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.HostsPerDomainTableModel;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.HostsPerDomainTableRenderer;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.OverviewTableModel;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.SumOfCountsPerHostnameTableModelV2;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.SumOfCountsPerHostnameTableRenderer;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.SumOfCountsPerHostnameTableTooltipHeader;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.TableTransferHandlerColumnFive;
import rs.co.ast.aspen.gui.module.datamaps.sourcestatistics.TableTransferHandlerColumnOne;

@TopComponent.Description(preferredID="SourceStatisticsTopComponent", iconBase="assetts-statistic.png", persistenceType=2)
public final class SourceStatisticsTopComponent
extends TopComponent {
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private final SumOfCountsPerHostnameTableModelV2 sumOfCountsPerHostnameTableModelV2 = new SumOfCountsPerHostnameTableModelV2();
    private static final String V2_VERSION = "7.3.14-SNAPSHOT";
    private final HostsPerDomainTableModel hostsPerDomainTablemodel = new HostsPerDomainTableModel();
    private final ComplementTableModel complementTableModelV2 = new ComplementTableModel();
    private final OverviewTableModel overviewTableModel = new OverviewTableModel();
    private final DateTimeFormatter dtf = ISODateTimeFormat.basicDateTimeNoMillis();
    private final long MS_IN_DAY = 86400000L;
    private final KeyAdapter keyAdapter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                SourceStatisticsTopComponent.this.startSearch();
            }
        }
    };
    private final ImageIcon redRefreshIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/red_arrow_refresh.png"));
    private final ImageIcon greenRefreshIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/arrow_refresh.png"));
    private Date prevTimeStart = new Date();
    private Date prevTimeFinish = new Date();
    private Date prevTimeStartComplement = new Date();
    private Date prevTimeFinishComplement = new Date();
    private boolean v2;
    private JButton bExport;
    private JButton bInfo;
    private JButton bRefresh;
    private JButton bRefreshComplement;
    private JComboBox<String> cbLastNDays;
    private JXDatePicker dtpTimeFinish;
    private JXDatePicker dtpTimeFinishComplementPeriod;
    private JXDatePicker dtpTimeStart;
    private JXDatePicker dtpTimeStartComplementPeriod;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel7;
    private JPanel jPanel9;
    private JRadioButtonMenuItem jRadioButtonMenuItem1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane6;
    private JLabel lDelimeter;
    private JLabel lFinish;
    private JLabel lFinish1;
    private JLabel lFinish2;
    private JXBusyLabel lLoading;
    private JLabel lQueryDomain;
    private JLabel lQueryHostname;
    private JLabel lStart;
    private JLabel lStart1;
    private JPanel pComplements;
    private JPanel pCountOfHostnamesPerDomain;
    private JPanel pSumOfCountsPerHostname;
    private JRadioButton rbComplement;
    private JRadioButton rbCustomDate;
    private JRadioButton rbLastNDays;
    private JRadioButton rbReverseDateComplement;
    private JTable tCountOfHostNamesPerDomain;
    private JTable tHostnamesComplement;
    private JTable tOverview;
    private JTable tSumOfCountsPerHostname;
    private JTabbedPane tbPanel;
    private JTextField tfComplementsFilter;
    private JTextField tfCountOfHostnamesPerDomainFilter;
    private JTextField tfDelimeter;
    private JTextField tfQueryDomain;
    private JTextField tfQueryHostname;
    private JTextField tfQueryIp;
    private JTextField tfQueryTags;
    private JTextField tfSumOfCountsPerHostnameFilter;

    public SourceStatisticsTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"CTL_SourceStatisticsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"HINT_SourceStatisticsTopComponent"));
        this.dtpTimeStart.setFormats(new String[]{"yyyy-MM-dd"});
        this.dtpTimeStart.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dtpTimeFinish.setFormats(new String[]{"yyyy-MM-dd"});
        this.dtpTimeFinish.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        long now = System.currentTimeMillis();
        this.dtpTimeStart.setDate(new DateTime(now - 604800000L).withTimeAtStartOfDay().toDate());
        this.dtpTimeFinish.setDate(new DateTime(now).withHourOfDay(0).withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0).toDate());
        this.dtpTimeStartComplementPeriod.setFormats(new String[]{"yyyy-MM-dd"});
        this.dtpTimeStartComplementPeriod.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dtpTimeStartComplementPeriod.setTimeZone(TimeZone.getDefault());
        this.dtpTimeStartComplementPeriod.setDate(new DateTime(this.getStartTime() - (long)(Integer.parseInt(this.cbLastNDays.getSelectedItem().toString()) + 1) * 86400000L).toDate());
        this.dtpTimeFinishComplementPeriod.setFormats(new String[]{"yyyy-MM-dd"});
        this.dtpTimeFinishComplementPeriod.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dtpTimeFinishComplementPeriod.setTimeZone(TimeZone.getDefault());
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.dtpTimeFinish.getDate());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.dtpTimeFinishComplementPeriod.setDate(new DateTime(cal.getTimeInMillis() - (long)(Integer.parseInt(this.cbLastNDays.getSelectedItem().toString()) + 1) * 86400000L).toDate());
        this.tSumOfCountsPerHostname.setModel(this.sumOfCountsPerHostnameTableModelV2);
        this.tSumOfCountsPerHostname.setDefaultRenderer(Long.class, new SumOfCountsPerHostnameTableRenderer());
        this.tSumOfCountsPerHostname.setTransferHandler(new TableTransferHandlerColumnFive());
        this.tSumOfCountsPerHostname.setAutoCreateRowSorter(true);
        SumOfCountsPerHostnameTableTooltipHeader sumOfCountsPerHostnameToolTipHeader = new SumOfCountsPerHostnameTableTooltipHeader(this.tSumOfCountsPerHostname.getColumnModel());
        this.tSumOfCountsPerHostname.setTableHeader(sumOfCountsPerHostnameToolTipHeader);
        final TableRowSorter<SumOfCountsPerHostnameTableModelV2> sumOfCountsPerHostnameTableSorter = new TableRowSorter<SumOfCountsPerHostnameTableModelV2>(this.sumOfCountsPerHostnameTableModelV2);
        this.tSumOfCountsPerHostname.setRowSorter(sumOfCountsPerHostnameTableSorter);
        this.tHostnamesComplement.setModel(this.complementTableModelV2);
        this.tHostnamesComplement.setDefaultRenderer(Long.class, new ComplementTableRenderer());
        this.tHostnamesComplement.setTransferHandler(new TableTransferHandlerColumnFive());
        this.tHostnamesComplement.setAutoCreateRowSorter(true);
        final TableRowSorter<ComplementTableModel> hostnamesComplementTableSorter = new TableRowSorter<ComplementTableModel>(this.complementTableModelV2);
        this.tHostnamesComplement.setRowSorter(hostnamesComplementTableSorter);
        this.tCountOfHostNamesPerDomain.setModel(this.hostsPerDomainTablemodel);
        this.tCountOfHostNamesPerDomain.setDefaultRenderer(Long.class, new HostsPerDomainTableRenderer());
        this.tCountOfHostNamesPerDomain.setTransferHandler(new TableTransferHandlerColumnOne());
        this.tCountOfHostNamesPerDomain.setAutoCreateRowSorter(true);
        final TableRowSorter<HostsPerDomainTableModel> countOfHostNamesPerDomainTableSorter = new TableRowSorter<HostsPerDomainTableModel>(this.hostsPerDomainTablemodel);
        this.tCountOfHostNamesPerDomain.setRowSorter(countOfHostNamesPerDomainTableSorter);
        this.tOverview.setModel(this.overviewTableModel);
        this.tOverview.setTransferHandler(new TableTransferHandler());
        this.tOverview.setAutoCreateRowSorter(true);
        this.tfQueryDomain.addKeyListener(this.keyAdapter);
        this.tfQueryHostname.addKeyListener(this.keyAdapter);
        this.tfQueryIp.addKeyListener(this.keyAdapter);
        this.tfQueryTags.addKeyListener(this.keyAdapter);
        this.tbPanel.setForegroundAt(1, new Color(51, 153, 255));
        this.tbPanel.setForegroundAt(2, new Color(173, 51, 255));
        this.tbPanel.setForegroundAt(3, new Color(255, 0, 0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbCustomDate);
        bg.add(this.rbLastNDays);
        ButtonGroup bgComplementsSwitch = new ButtonGroup();
        bgComplementsSwitch.add(this.rbComplement);
        bgComplementsSwitch.add(this.rbReverseDateComplement);
        this.rbLastNDays.setSelected(true);
        this.rbComplement.setSelected(true);
        this.dtpTimeFinishComplementPeriod.setEnabled(false);
        this.dtpTimeStartComplementPeriod.setEnabled(false);
        this.rbLastNDays.addActionListener(e -> {
            this.cbLastNDays.setEnabled(true);
            this.dtpTimeFinishComplementPeriod.setDate(new DateTime(this.getStartTime() - (long)Integer.parseInt(this.cbLastNDays.getSelectedItem().toString()) * 86400000L).toDate());
            this.dtpTimeStartComplementPeriod.setDate(new DateTime(this.getFinishComplementPeriodTime() - (this.getFinishTime() - this.getStartTime())).toDate());
            this.dtpTimeFinishComplementPeriod.setEnabled(false);
            this.dtpTimeStartComplementPeriod.setEnabled(false);
        });
        this.rbCustomDate.addActionListener(e -> {
            this.cbLastNDays.setEnabled(false);
            this.dtpTimeFinishComplementPeriod.setEnabled(true);
            this.dtpTimeStartComplementPeriod.setEnabled(true);
        });
        this.cbLastNDays.addActionListener(e -> {
            this.dtpTimeFinishComplementPeriod.setDate(new DateTime(this.getStartTime() - (long)Integer.parseInt(this.cbLastNDays.getSelectedItem().toString()) * 86400000L).toDate());
            this.dtpTimeStartComplementPeriod.setDate(new DateTime(this.getFinishComplementPeriodTime() - (this.getFinishTime() - this.getStartTime())).toDate());
            if (this.dtpTimeStartComplementPeriod.getDate().equals(this.prevTimeStartComplement) && this.dtpTimeFinishComplementPeriod.getDate().equals(this.prevTimeFinishComplement)) {
                this.bRefreshComplement.setIcon(this.greenRefreshIcon);
            } else {
                this.bRefreshComplement.setIcon(this.redRefreshIcon);
            }
        });
        this.dtpTimeStart.addActionListener(e -> {
            if (this.dtpTimeStart.getDate().equals(this.prevTimeStart)) {
                this.bRefresh.setIcon(this.greenRefreshIcon);
            } else {
                this.bRefresh.setIcon(this.redRefreshIcon);
            }
            if (this.rbLastNDays.isSelected()) {
                this.dtpTimeFinishComplementPeriod.setDate(new DateTime(this.getStartTime() - (long)Integer.parseInt(this.cbLastNDays.getSelectedItem().toString()) * 86400000L).toDate());
                this.dtpTimeStartComplementPeriod.setDate(new DateTime(this.getFinishComplementPeriodTime() - (this.getFinishTime() - this.getStartTime())).toDate());
            }
        });
        this.dtpTimeFinish.addActionListener(e -> {
            if (this.dtpTimeFinish.getDate().equals(this.prevTimeFinish)) {
                this.bRefresh.setIcon(this.greenRefreshIcon);
            } else {
                this.bRefresh.setIcon(this.redRefreshIcon);
            }
            if (this.rbLastNDays.isSelected()) {
                this.dtpTimeFinishComplementPeriod.setDate(new DateTime(this.getStartTime() - (long)Integer.parseInt(this.cbLastNDays.getSelectedItem().toString()) * 86400000L).toDate());
                this.dtpTimeStartComplementPeriod.setDate(new DateTime(this.getFinishComplementPeriodTime() - (this.getFinishTime() - this.getStartTime())).toDate());
            }
        });
        this.dtpTimeStartComplementPeriod.addActionListener(e -> {
            if (this.dtpTimeStartComplementPeriod.getDate().equals(this.prevTimeStartComplement)) {
                this.bRefreshComplement.setIcon(this.greenRefreshIcon);
            } else {
                this.bRefreshComplement.setIcon(this.redRefreshIcon);
            }
        });
        this.dtpTimeFinishComplementPeriod.addActionListener(e -> {
            if (this.dtpTimeFinishComplementPeriod.getDate().equals(this.prevTimeFinishComplement)) {
                this.bRefreshComplement.setIcon(this.greenRefreshIcon);
            } else {
                this.bRefreshComplement.setIcon(this.redRefreshIcon);
            }
        });
        this.rbComplement.addActionListener(e -> this.complementTableModelV2.showComplement(true));
        this.rbReverseDateComplement.addActionListener(e -> this.complementTableModelV2.showComplement(false));
        this.tfCountOfHostnamesPerDomainFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.filter();
            }

            private void filter() {
                String text = SourceStatisticsTopComponent.this.tfCountOfHostnamesPerDomainFilter.getText();
                if (text.length() == 0) {
                    countOfHostNamesPerDomainTableSorter.setRowFilter(null);
                } else {
                    try {
                        countOfHostNamesPerDomainTableSorter.setRowFilter(RowFilter.regexFilter(text, new int[0]));
                    }
                    catch (PatternSyntaxException pse) {
                        System.out.println("Bad regex pattern");
                    }
                }
            }
        });
        this.tfSumOfCountsPerHostnameFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.filter();
            }

            private void filter() {
                String text = SourceStatisticsTopComponent.this.tfSumOfCountsPerHostnameFilter.getText();
                if (text.length() == 0) {
                    sumOfCountsPerHostnameTableSorter.setRowFilter(null);
                } else {
                    try {
                        sumOfCountsPerHostnameTableSorter.setRowFilter(RowFilter.regexFilter(text, new int[0]));
                    }
                    catch (PatternSyntaxException pse) {
                        System.out.println("Bad regex pattern");
                    }
                }
            }
        });
        this.tfComplementsFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.filter();
            }

            private void filter() {
                String text = SourceStatisticsTopComponent.this.tfComplementsFilter.getText();
                if (text.length() == 0) {
                    hostnamesComplementTableSorter.setRowFilter(null);
                } else {
                    try {
                        hostnamesComplementTableSorter.setRowFilter(RowFilter.regexFilter(text, new int[0]));
                    }
                    catch (PatternSyntaxException pse) {
                        System.out.println("Bad regex pattern");
                    }
                }
            }
        });
    }

    public long getStartTime() {
        return this.dtpTimeStart.getDate().getTime();
    }

    public long getFinishTime() {
        return this.getEndOfDayFrom(this.dtpTimeFinish.getDate().getTime());
    }

    public long getStartComplementPeriodTime() {
        return this.dtpTimeStartComplementPeriod.getDate().getTime();
    }

    public long getFinishComplementPeriodTime() {
        return this.getEndOfDayFrom(this.dtpTimeFinishComplementPeriod.getDate().getTime());
    }

    private long getEndOfDayFrom(long time) {
        return time + 86400000L;
    }

    public String getQueryDomain() {
        return this.tfQueryDomain.getText();
    }

    public String getQueryHostname() {
        return this.tfQueryHostname.getText();
    }

    public String getQueryIp() {
        return this.tfQueryIp.getText();
    }

    public String getQueryTags() {
        return this.tfQueryTags.getText();
    }

    public String getDelimeter() {
        return this.tfDelimeter.getText();
    }

    private void toggleLoading() {
        this.lLoading.setBusy(!this.lLoading.isBusy());
    }

    private String genFileName() {
        DateTime now = new DateTime();
        String ext = "csv";
        return String.format("%s_%s.%s", "SourceStatistics", now.toString(this.dtf), ext);
    }

    private void initComponents() {
        this.jRadioButtonMenuItem1 = new JRadioButtonMenuItem();
        this.jPanel5 = new JPanel();
        this.jLabel4 = new JLabel();
        this.lDelimeter = new JLabel();
        this.tfDelimeter = new JTextField();
        this.bExport = new JButton();
        this.tbPanel = new JTabbedPane();
        this.jScrollPane3 = new JScrollPane();
        this.tOverview = new JTable();
        this.pCountOfHostnamesPerDomain = new JPanel();
        this.jPanel7 = new JPanel();
        this.jLabel7 = new JLabel();
        this.tfCountOfHostnamesPerDomainFilter = new JTextField();
        this.jScrollPane4 = new JScrollPane();
        this.tCountOfHostNamesPerDomain = new JTable();
        this.pSumOfCountsPerHostname = new JPanel();
        this.jPanel9 = new JPanel();
        this.jLabel8 = new JLabel();
        this.tfSumOfCountsPerHostnameFilter = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.tSumOfCountsPerHostname = new JTable();
        this.pComplements = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.rbCustomDate = new JRadioButton();
        this.lStart1 = new JLabel();
        this.dtpTimeStartComplementPeriod = new JXDatePicker();
        this.lFinish1 = new JLabel();
        this.dtpTimeFinishComplementPeriod = new JXDatePicker();
        this.jPanel2 = new JPanel();
        this.rbLastNDays = new JRadioButton();
        this.lFinish2 = new JLabel();
        this.cbLastNDays = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jScrollPane6 = new JScrollPane();
        this.tHostnamesComplement = new JTable();
        this.rbComplement = new JRadioButton();
        this.rbReverseDateComplement = new JRadioButton();
        this.bRefreshComplement = new JButton();
        this.bInfo = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel9 = new JLabel();
        this.tfComplementsFilter = new JTextField();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.lQueryDomain = new JLabel();
        this.lLoading = new JXBusyLabel();
        this.tfQueryDomain = new JTextField();
        this.bRefresh = new JButton();
        this.lQueryHostname = new JLabel();
        this.tfQueryHostname = new JTextField();
        this.lStart = new JLabel();
        this.dtpTimeStart = new JXDatePicker();
        this.lFinish = new JLabel();
        this.dtpTimeFinish = new JXDatePicker();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.tfQueryIp = new JTextField();
        this.tfQueryTags = new JTextField();
        this.jRadioButtonMenuItem1.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonMenuItem1, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jRadioButtonMenuItem1.text"));
        this.jPanel5.setPreferredSize(new Dimension(113, 148));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jLabel4.text"));
        Mnemonics.setLocalizedText((JLabel)this.lDelimeter, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lDelimeter.text"));
        this.tfDelimeter.setHorizontalAlignment(0);
        this.tfDelimeter.setText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfDelimeter.text"));
        this.tfDelimeter.setToolTipText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfDelimeter.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.bExport, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.bExport.text"));
        this.bExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceStatisticsTopComponent.this.bExportActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.lDelimeter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfDelimeter, -2, 1, Short.MAX_VALUE)).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel4).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.bExport, -1, 101, Short.MAX_VALUE)).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addGap(18, 18, Short.MAX_VALUE).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lDelimeter).addComponent(this.tfDelimeter, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bExport).addContainerGap()));
        this.tOverview.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tOverview.setCellSelectionEnabled(true);
        this.jScrollPane3.setViewportView(this.tOverview);
        this.tbPanel.addTab(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jScrollPane3.TabConstraints.tabTitle"), this.jScrollPane3);
        this.pCountOfHostnamesPerDomain.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jLabel7.text"));
        this.tfCountOfHostnamesPerDomainFilter.setText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfCountOfHostnamesPerDomainFilter.text"));
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfCountOfHostnamesPerDomainFilter).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.tfCountOfHostnamesPerDomainFilter, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pCountOfHostnamesPerDomain.add((Component)this.jPanel7, "North");
        this.tCountOfHostNamesPerDomain.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.tCountOfHostNamesPerDomain.setCellSelectionEnabled(true);
        this.jScrollPane4.setViewportView(this.tCountOfHostNamesPerDomain);
        this.pCountOfHostnamesPerDomain.add((Component)this.jScrollPane4, "Center");
        this.tbPanel.addTab(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.pCountOfHostnamesPerDomain.TabConstraints.tabTitle"), this.pCountOfHostnamesPerDomain);
        this.pSumOfCountsPerHostname.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jLabel8.text"));
        this.tfSumOfCountsPerHostnameFilter.setText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfSumOfCountsPerHostnameFilter.text"));
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSumOfCountsPerHostnameFilter).addContainerGap()));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.tfSumOfCountsPerHostnameFilter, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pSumOfCountsPerHostname.add((Component)this.jPanel9, "North");
        this.tSumOfCountsPerHostname.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.tSumOfCountsPerHostname.setCellSelectionEnabled(true);
        this.jScrollPane1.setViewportView(this.tSumOfCountsPerHostname);
        this.pSumOfCountsPerHostname.add((Component)this.jScrollPane1, "Center");
        this.tbPanel.addTab(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.pSumOfCountsPerHostname.TabConstraints.tabTitle"), this.pSumOfCountsPerHostname);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jLabel2.text"));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        Mnemonics.setLocalizedText((AbstractButton)this.rbCustomDate, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.rbCustomDate.text"));
        Mnemonics.setLocalizedText((JLabel)this.lStart1, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lStart1.text"));
        Mnemonics.setLocalizedText((JLabel)this.lFinish1, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lFinish1.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbCustomDate).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lStart1).addComponent(this.lFinish1, GroupLayout.Alignment.TRAILING)).addGap(12, 12, 12).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.dtpTimeStartComplementPeriod, -1, -1, Short.MAX_VALUE).addComponent((Component)this.dtpTimeFinishComplementPeriod, -1, -1, Short.MAX_VALUE)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.rbCustomDate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lStart1).addComponent((Component)this.dtpTimeStartComplementPeriod, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.dtpTimeFinishComplementPeriod, -2, -1, -2).addComponent(this.lFinish1)).addContainerGap(14, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setPreferredSize(new Dimension(228, 87));
        Mnemonics.setLocalizedText((AbstractButton)this.rbLastNDays, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.rbLastNDays.text"));
        Mnemonics.setLocalizedText((JLabel)this.lFinish2, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lFinish2.text"));
        this.cbLastNDays.setModel(new DefaultComboBoxModel<String>(new String[]{"7", "14", "21", "30", "60"}));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jLabel1.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.lFinish2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbLastNDays, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1)).addComponent(this.rbLastNDays)).addContainerGap(47, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.rbLastNDays).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lFinish2).addComponent(this.cbLastNDays, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        this.tHostnamesComplement.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.tHostnamesComplement.setCellSelectionEnabled(true);
        this.jScrollPane6.setViewportView(this.tHostnamesComplement);
        Mnemonics.setLocalizedText((AbstractButton)this.rbComplement, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.rbComplement.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.rbReverseDateComplement, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.rbReverseDateComplement.text"));
        this.bRefreshComplement.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/arrow_refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bRefreshComplement, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.bRefreshComplement.text"));
        this.bRefreshComplement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceStatisticsTopComponent.this.bRefreshComplementActionPerformed(evt);
            }
        });
        this.bInfo.setFont(new Font("sansserif", 2, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.bInfo, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.bInfo.text"));
        this.bInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceStatisticsTopComponent.this.bInfoActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jLabel9.text"));
        this.tfComplementsFilter.setText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfComplementsFilter.text"));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfComplementsFilter).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.tfComplementsFilter, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout pComplementsLayout = new GroupLayout(this.pComplements);
        this.pComplements.setLayout(pComplementsLayout);
        pComplementsLayout.setHorizontalGroup(pComplementsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pComplementsLayout.createSequentialGroup().addContainerGap().addGroup(pComplementsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pComplementsLayout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addGroup(pComplementsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bRefreshComplement).addComponent(this.rbComplement, -1, 799, Short.MAX_VALUE).addComponent(this.rbReverseDateComplement, -1, -1, Short.MAX_VALUE))).addGroup(pComplementsLayout.createSequentialGroup().addGroup(pComplementsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addGroup(pComplementsLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.bInfo)).addComponent(this.jScrollPane6, GroupLayout.Alignment.TRAILING)).addContainerGap()))));
        pComplementsLayout.setVerticalGroup(pComplementsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pComplementsLayout.createSequentialGroup().addContainerGap().addGroup(pComplementsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.bInfo)).addGap(8, 8, 8).addGroup(pComplementsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pComplementsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, 115, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGroup(pComplementsLayout.createSequentialGroup().addComponent(this.bRefreshComplement).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rbComplement).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbReverseDateComplement))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane6, -1, 350, Short.MAX_VALUE).addContainerGap()));
        this.tbPanel.addTab(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.pComplements.TabConstraints.tabTitle"), this.pComplements);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jLabel3.text"));
        Mnemonics.setLocalizedText((JLabel)this.lQueryDomain, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lQueryDomain.text"));
        this.lLoading.setBackground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.lLoading, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lLoading.text"));
        this.lLoading.setDirection(BusyPainter.Direction.RIGHT);
        this.tfQueryDomain.setText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfQueryDomain.text"));
        this.tfQueryDomain.setToolTipText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfQueryDomain.toolTipText"));
        this.bRefresh.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/arrow_refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bRefresh, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.bRefresh.text"));
        this.bRefresh.setToolTipText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.bRefresh.toolTipText"));
        this.bRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceStatisticsTopComponent.this.bRefreshActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lQueryHostname, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lQueryHostname.text"));
        this.tfQueryHostname.setText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfQueryHostname.text"));
        this.tfQueryHostname.setToolTipText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfQueryHostname.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.lStart, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lStart.text"));
        Mnemonics.setLocalizedText((JLabel)this.lFinish, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.lFinish.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jLabel5.text", (Object[])new Object[0]));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.jLabel6.text", (Object[])new Object[0]));
        this.tfQueryIp.setText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfQueryIp.text", (Object[])new Object[0]));
        this.tfQueryIp.setToolTipText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfQueryIp.toolTipText", (Object[])new Object[0]));
        this.tfQueryTags.setText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfQueryTags.text", (Object[])new Object[0]));
        this.tfQueryTags.setToolTipText(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.tfQueryTags.toolTipText", (Object[])new Object[0]));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.bRefresh, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.lLoading, -2, -1, -2)).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lQueryHostname).addComponent(this.lQueryDomain)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfQueryHostname).addComponent(this.tfQueryDomain)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfQueryIp).addComponent(this.tfQueryTags)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel3Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.lStart)).addComponent(this.lFinish)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dtpTimeStart, -2, -1, -2).addComponent((Component)this.dtpTimeFinish, -2, -1, -2)))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -2, 27, -2).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.lLoading, GroupLayout.Alignment.TRAILING, -2, 27, -2).addComponent(this.bRefresh, GroupLayout.Alignment.TRAILING, -2, 27, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lStart).addComponent((Component)this.dtpTimeStart, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.dtpTimeFinish, -2, -1, -2).addComponent(this.lFinish))).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfQueryHostname, -2, -1, -2).addComponent(this.lQueryHostname).addComponent(this.jLabel5).addComponent(this.tfQueryIp, -2, -1, -2)).addGap(7, 7, 7).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfQueryDomain, -2, -1, -2).addComponent(this.lQueryDomain).addComponent(this.jLabel6).addComponent(this.tfQueryTags, -2, -1, -2)))).addContainerGap(10, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tbPanel)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tbPanel).addContainerGap()));
    }

    private void bExportActionPerformed(ActionEvent evt) {
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsPanel.export_progress.title"));
        SwingWorker<HostStatsCsvReport, Void> worker = new SwingWorker<HostStatsCsvReport, Void>(){

            @Override
            protected HostStatsCsvReport doInBackground() throws Exception {
                SourceStatisticsTopComponent.this.toggleLoading();
                try {
                    ph.start();
                    return SourceStatisticsTopComponent.this.apiService.hostCsvReport(SourceStatisticsTopComponent.this.getQueryHostname(), SourceStatisticsTopComponent.this.getQueryHostname(), SourceStatisticsTopComponent.this.getStartTime(), SourceStatisticsTopComponent.this.getFinishTime(), SourceStatisticsTopComponent.this.getDelimeter());
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    SourceStatisticsTopComponent.this.toggleLoading();
                    ph.finish();
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                block11: {
                    try {
                        HostStatsCsvReport hostCsvReport = (HostStatsCsvReport)this.get();
                        String fileName = SourceStatisticsTopComponent.this.genFileName();
                        JFileChooser saveDialog = new JFileChooser();
                        saveDialog.setDialogTitle(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.saveDialog.title"));
                        saveDialog.setDialogType(1);
                        saveDialog.setSelectedFile(new File(fileName));
                        int actionDialog = saveDialog.showSaveDialog(WindowManager.getDefault().getMainWindow());
                        if (actionDialog == 0) {
                            File dfile = new File(saveDialog.getCurrentDirectory(), saveDialog.getSelectedFile().getName());
                            dfile.createNewFile();
                            try (FileOutputStream stream = new FileOutputStream(dfile);){
                                stream.write(hostCsvReport.getDataHandler());
                                break block11;
                            }
                        }
                        ph.finish();
                    }
                    catch (IOException | InterruptedException | ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        SourceStatisticsTopComponent.this.toggleLoading();
                        ph.finish();
                    }
                }
            }
        };
        worker.execute();
    }

    private void bRefreshActionPerformed(ActionEvent evt) {
        this.startSearch();
    }

    private void bRefreshComplementActionPerformed(ActionEvent evt) {
        if (this.v2) {
            this.startComplementSearchV2();
        } else {
            this.startComplementSearch();
        }
    }

    private void bInfoActionPerformed(ActionEvent evt) {
        ComplementInfoPanel complementInfoPanel = new ComplementInfoPanel();
        DialogDescriptor des = new DialogDescriptor((Object)complementInfoPanel, NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.ComplementInfoPanel.title"));
        Dialog d = DialogDisplayer.getDefault().createDialog(des);
        d.setVisible(true);
    }

    private String getShortDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return formatter.format(cal.getTime());
    }

    public void setDatesToLabelsInComplementsTab() {
        String rbComplementText = String.format(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.ComplementsRadioButton.text"), this.getShortDate(this.prevTimeStart), this.getShortDate(this.prevTimeFinish), this.getShortDate(this.prevTimeStartComplement), this.getShortDate(this.prevTimeFinishComplement));
        String rbReverseDateComplementText = String.format(NbBundle.getMessage(SourceStatisticsTopComponent.class, (String)"SourceStatisticsTopComponent.ComplementsRadioButton.text"), this.getShortDate(this.prevTimeStartComplement), this.getShortDate(this.prevTimeFinishComplement), this.getShortDate(this.prevTimeStart), this.getShortDate(this.prevTimeFinish));
        this.rbComplement.setText(rbComplementText);
        this.rbReverseDateComplement.setText(rbReverseDateComplementText);
    }

    public void trackMainSearchDates() {
        this.prevTimeStart = this.dtpTimeStart.getDate();
        this.prevTimeFinish = this.dtpTimeFinish.getDate();
    }

    public void trackComplementSearchDates() {
        this.prevTimeStartComplement = this.dtpTimeStartComplementPeriod.getDate();
        this.prevTimeFinishComplement = this.dtpTimeFinishComplementPeriod.getDate();
    }

    private void startSearch() {
        this.trackMainSearchDates();
        this.setDatesToLabelsInComplementsTab();
        if (this.v2) {
            this.hostGuiReportV2();
        } else {
            this.hostGuiReport();
        }
    }

    private void hostGuiReportV2() {
        SwingWorker<EnrichedHostStatsGuiReport, Void> worker = new SwingWorker<EnrichedHostStatsGuiReport, Void>(){

            @Override
            protected EnrichedHostStatsGuiReport doInBackground() throws Exception {
                SourceStatisticsTopComponent.this.toggleLoading();
                try {
                    return SourceStatisticsTopComponent.this.apiService.hostGuiReport(SourceStatisticsTopComponent.this.getQueryHostname(), SourceStatisticsTopComponent.this.getQueryDomain(), SourceStatisticsTopComponent.this.getQueryIp(), SourceStatisticsTopComponent.this.getQueryTags(), SourceStatisticsTopComponent.this.getStartTime(), SourceStatisticsTopComponent.this.getFinishTime());
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    SourceStatisticsTopComponent.this.toggleLoading();
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    EnrichedHostStatsGuiReport hostGuiReport = (EnrichedHostStatsGuiReport)this.get();
                    SourceStatisticsTopComponent.this.overviewTableModel.update(hostGuiReport.getOverview());
                    List hostsPerDomain = hostGuiReport.getHostsPerDomain();
                    SourceStatisticsTopComponent.this.hostsPerDomainTablemodel.update(hostsPerDomain);
                    List sumOfCountsPerHostname = hostGuiReport.getSumOfCountsPerHostname();
                    SourceStatisticsTopComponent.this.sumOfCountsPerHostnameTableModelV2.update(sumOfCountsPerHostname);
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    SourceStatisticsTopComponent.this.toggleLoading();
                }
                finally {
                    SourceStatisticsTopComponent.this.toggleLoading();
                    SourceStatisticsTopComponent.this.bRefresh.setIcon(SourceStatisticsTopComponent.this.greenRefreshIcon);
                    SourceStatisticsTopComponent.this.startComplementSearchV2();
                }
            }
        };
        worker.execute();
    }

    private void hostGuiReport() {
        SwingWorker<EnrichedHostStatsGuiReport, Void> worker = new SwingWorker<EnrichedHostStatsGuiReport, Void>(){

            @Override
            protected EnrichedHostStatsGuiReport doInBackground() throws Exception {
                SourceStatisticsTopComponent.this.toggleLoading();
                try {
                    return SourceStatisticsTopComponent.this.apiService.hostStatGuiReport(SourceStatisticsTopComponent.this.getQueryHostname(), SourceStatisticsTopComponent.this.getQueryDomain(), SourceStatisticsTopComponent.this.getStartTime(), SourceStatisticsTopComponent.this.getFinishTime());
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    SourceStatisticsTopComponent.this.toggleLoading();
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    EnrichedHostStatsGuiReport hostGuiReport = (EnrichedHostStatsGuiReport)this.get();
                    SourceStatisticsTopComponent.this.overviewTableModel.update(hostGuiReport.getOverview());
                    List hostsPerDomain = hostGuiReport.getHostsPerDomain();
                    SourceStatisticsTopComponent.this.hostsPerDomainTablemodel.update(hostsPerDomain);
                    List sumOfCountsPerHostname = hostGuiReport.getSumOfCountsPerHostname();
                    SourceStatisticsTopComponent.this.sumOfCountsPerHostnameTableModelV2.update(sumOfCountsPerHostname);
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    SourceStatisticsTopComponent.this.toggleLoading();
                }
                finally {
                    SourceStatisticsTopComponent.this.toggleLoading();
                    SourceStatisticsTopComponent.this.bRefresh.setIcon(SourceStatisticsTopComponent.this.greenRefreshIcon);
                    SourceStatisticsTopComponent.this.startComplementSearch();
                }
            }
        };
        worker.execute();
    }

    private void startComplementSearch() {
        this.trackComplementSearchDates();
        this.setDatesToLabelsInComplementsTab();
        SwingWorker<EnrichedHostStatsGuiReport, Void> worker = new SwingWorker<EnrichedHostStatsGuiReport, Void>(){

            @Override
            protected EnrichedHostStatsGuiReport doInBackground() throws Exception {
                try {
                    return SourceStatisticsTopComponent.this.apiService.hostStatGuiReport(SourceStatisticsTopComponent.this.getQueryHostname(), SourceStatisticsTopComponent.this.getQueryDomain(), SourceStatisticsTopComponent.this.getStartComplementPeriodTime(), SourceStatisticsTopComponent.this.getFinishComplementPeriodTime());
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    EnrichedHostStatsGuiReport hostGuiReport = (EnrichedHostStatsGuiReport)this.get();
                    List sumOfCountsPerHostname = hostGuiReport.getSumOfCountsPerHostname();
                    boolean order = this.checkIfComplementDatesIsBehindMainDates();
                    SourceStatisticsTopComponent.this.complementTableModelV2.update(SourceStatisticsTopComponent.this.sumOfCountsPerHostnameTableModelV2.getData(), sumOfCountsPerHostname, order);
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    SourceStatisticsTopComponent.this.bRefreshComplement.setIcon(SourceStatisticsTopComponent.this.greenRefreshIcon);
                }
            }

            private boolean checkIfComplementDatesIsBehindMainDates() {
                Date timeStart = SourceStatisticsTopComponent.this.dtpTimeStart.getDate();
                Date timeFinish = SourceStatisticsTopComponent.this.dtpTimeFinish.getDate();
                Date complementTimeStart = SourceStatisticsTopComponent.this.dtpTimeStartComplementPeriod.getDate();
                Date complementTimeFinish = SourceStatisticsTopComponent.this.dtpTimeFinishComplementPeriod.getDate();
                if (timeStart.after(complementTimeStart) && timeFinish.after(complementTimeFinish)) {
                    return true;
                }
                return timeStart.after(complementTimeStart) && (timeStart.equals(complementTimeFinish) || timeStart.before(complementTimeFinish));
            }
        };
        worker.execute();
    }

    private void startComplementSearchV2() {
        this.trackComplementSearchDates();
        this.setDatesToLabelsInComplementsTab();
        SwingWorker<EnrichedHostStatsGuiReport, Void> worker = new SwingWorker<EnrichedHostStatsGuiReport, Void>(){

            @Override
            protected EnrichedHostStatsGuiReport doInBackground() throws Exception {
                try {
                    return SourceStatisticsTopComponent.this.apiService.hostGuiReport(SourceStatisticsTopComponent.this.getQueryHostname(), SourceStatisticsTopComponent.this.getQueryDomain(), SourceStatisticsTopComponent.this.getQueryIp(), SourceStatisticsTopComponent.this.getQueryTags(), SourceStatisticsTopComponent.this.getStartComplementPeriodTime(), SourceStatisticsTopComponent.this.getFinishComplementPeriodTime());
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    EnrichedHostStatsGuiReport hostGuiReport = (EnrichedHostStatsGuiReport)this.get();
                    List sumOfCountsPerHostname = hostGuiReport.getSumOfCountsPerHostname();
                    boolean order = this.checkIfComplementDatesIsBehindMainDates();
                    SourceStatisticsTopComponent.this.complementTableModelV2.update(SourceStatisticsTopComponent.this.sumOfCountsPerHostnameTableModelV2.getData(), sumOfCountsPerHostname, order);
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    SourceStatisticsTopComponent.this.bRefreshComplement.setIcon(SourceStatisticsTopComponent.this.greenRefreshIcon);
                }
            }

            private boolean checkIfComplementDatesIsBehindMainDates() {
                Date timeStart = SourceStatisticsTopComponent.this.dtpTimeStart.getDate();
                Date timeFinish = SourceStatisticsTopComponent.this.dtpTimeFinish.getDate();
                Date complementTimeStart = SourceStatisticsTopComponent.this.dtpTimeStartComplementPeriod.getDate();
                Date complementTimeFinish = SourceStatisticsTopComponent.this.dtpTimeFinishComplementPeriod.getDate();
                if (timeStart.after(complementTimeStart) && timeFinish.after(complementTimeFinish)) {
                    return true;
                }
                return timeStart.after(complementTimeStart) && (timeStart.equals(complementTimeFinish) || timeStart.before(complementTimeFinish));
            }
        };
        worker.execute();
    }

    public void componentOpened() {
        try {
            String serverApiVersion = this.apiService.getServerApiVersion();
            Version apiVersion = Version.valueOf((String)serverApiVersion);
            Version v2Version = Version.valueOf((String)V2_VERSION);
            this.v2 = apiVersion.greaterThanOrEqualTo(v2Version);
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.startSearch();
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

