/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.login;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ComplexityViolation;
import rs.co.ast.aspen.gui.module.login.PasswordPromptPanel;

public final class ChangePasswordAction
implements ActionListener {
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private PasswordPromptPanel panel = new PasswordPromptPanel();
    private DialogDescriptor d;
    private ActionListener listener;
    private String username = this.getUsername();

    public ChangePasswordAction() {
        this.listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block9: {
                    int opt = (Integer)e.getSource();
                    if (DialogDescriptor.OK_OPTION.equals(opt)) {
                        String password = ChangePasswordAction.this.panel.getOldPassword();
                        String newPassword = ChangePasswordAction.this.panel.getNewPassword();
                        String confirmNewPassword = ChangePasswordAction.this.panel.getConfirmNewPassword();
                        if (!password.isEmpty() && newPassword.equals(confirmNewPassword)) {
                            try {
                                List checkPasswordComplexity = ChangePasswordAction.this.apiService.checkPasswordComplexity(newPassword);
                                if (checkPasswordComplexity.isEmpty()) {
                                    if (!ChangePasswordAction.this.username.isEmpty()) {
                                        ChangePasswordAction.this.changePasswordForSelf(ChangePasswordAction.this.username, password, newPassword);
                                    } else {
                                        ChangePasswordAction.this.panel.setErrorMessage(NbBundle.getMessage(ChangePasswordAction.class, (String)"ChangePasswordAction.username_empty.text"));
                                    }
                                    ChangePasswordAction.this.d.setClosingOptions(null);
                                    break block9;
                                }
                                ChangePasswordAction.this.panel.setErrorMessage(ChangePasswordAction.this.passwordComplexityViolationsToString(checkPasswordComplexity));
                            }
                            catch (ApiServiceException_Exception ex) {
                                ChangePasswordAction.this.panel.setErrorMessage(ex.getLocalizedMessage());
                            }
                        } else {
                            ChangePasswordAction.this.panel.setErrorMessage(NbBundle.getMessage(ChangePasswordAction.class, (String)"ChangePasswordAction.passwords_dont_match.text"));
                        }
                    } else {
                        ChangePasswordAction.this.d.setClosingOptions(null);
                    }
                }
            }
        };
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.d = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(ChangePasswordAction.class, (String)"ChangePasswordAction.password_set.title"), true, this.listener);
        this.d.setClosingOptions(new Object[0]);
        DialogDisplayer.getDefault().createDialog(this.d).setVisible(true);
    }

    private void changePasswordForSelf(String username, String oldPassword, String newPassword) throws ApiServiceException_Exception {
        this.apiService.setConsoleUserPasswordForSelf(username, oldPassword, newPassword);
    }

    private String getUsername() {
        String usr;
        String[] split = WindowManager.getDefault().getMainWindow().getTitle().split("@");
        if (split.length == 2 && !(usr = split[1]).isEmpty()) {
            return usr;
        }
        return "";
    }

    private String passwordComplexityViolationsToString(List<ComplexityViolation> checkPasswordComplexity) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        for (ComplexityViolation cv : checkPasswordComplexity) {
            sb.append(cv.getMessage());
            sb.append("<br/>");
        }
        sb.append("</html>");
        return sb.toString();
    }
}

