/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.style;

import java.util.ArrayList;
import java.util.Map;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JREvaluation;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.style.StyleProvider;
import net.sf.jasperreports.engine.style.StyleProviderContext;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.FillEnum;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class PropertyStyleProvider
implements StyleProvider {
    public static final String STYLE_PROPERTY_PREFIX = "net.sf.jasperreports.style.";
    public static final String STYLE_PROPERTY_PEN_PREFIX = "net.sf.jasperreports.style.pen.";
    public static final String STYLE_PROPERTY_BOX_PREFIX = "net.sf.jasperreports.style.box.";
    public static final String STYLE_PROPERTY_BOX_PEN_PREFIX = "net.sf.jasperreports.style.box.pen.";
    public static final String STYLE_PROPERTY_BOX_LEFT_PEN_PREFIX = "net.sf.jasperreports.style.box.left.pen.";
    public static final String STYLE_PROPERTY_BOX_TOP_PEN_PREFIX = "net.sf.jasperreports.style.box.top.pen.";
    public static final String STYLE_PROPERTY_BOX_RIGHT_PEN_PREFIX = "net.sf.jasperreports.style.box.right.pen.";
    public static final String STYLE_PROPERTY_BOX_BOTTOM_PEN_PREFIX = "net.sf.jasperreports.style.box.bottom.pen.";
    public static final String STYLE_PROPERTY_PARAGRAPH_PREFIX = "net.sf.jasperreports.style.paragraph.";
    public static final String STYLE_PROPERTY_MODE = "net.sf.jasperreports.style.mode";
    public static final String STYLE_PROPERTY_BACKCOLOR = "net.sf.jasperreports.style.backcolor";
    public static final String STYLE_PROPERTY_FORECOLOR = "net.sf.jasperreports.style.forecolor";
    public static final String STYLE_PROPERTY_FILL = "net.sf.jasperreports.style.fill";
    public static final String STYLE_PROPERTY_RADIUS = "net.sf.jasperreports.style.radius";
    public static final String STYLE_PROPERTY_SCALE_IMAGE = "net.sf.jasperreports.style.scaleImage";
    public static final String STYLE_PROPERTY_HALIGN = "net.sf.jasperreports.style.hAlign";
    public static final String STYLE_PROPERTY_H_TEXT_ALIGN = "net.sf.jasperreports.style.hTextAlign";
    public static final String STYLE_PROPERTY_H_IMAGE_ALIGN = "net.sf.jasperreports.style.hImageAlign";
    public static final String STYLE_PROPERTY_VALIGN = "net.sf.jasperreports.style.vAlign";
    public static final String STYLE_PROPERTY_V_TEXT_ALIGN = "net.sf.jasperreports.style.vTextAlign";
    public static final String STYLE_PROPERTY_V_IMAGE_ALIGN = "net.sf.jasperreports.style.vImageAlign";
    public static final String STYLE_PROPERTY_ROTATION = "net.sf.jasperreports.style.rotation";
    public static final String STYLE_PROPERTY_MARKUP = "net.sf.jasperreports.style.markup";
    public static final String STYLE_PROPERTY_PATTERN = "net.sf.jasperreports.style.pattern";
    public static final String STYLE_PROPERTY_BLANK_WHEN_NULL = "net.sf.jasperreports.style.isBlankWhenNull";
    public static final String STYLE_PROPERTY_FONT_NAME = "net.sf.jasperreports.style.fontName";
    public static final String STYLE_PROPERTY_FONT_SIZE = "net.sf.jasperreports.style.fontSize";
    public static final String STYLE_PROPERTY_FONT_BOLD = "net.sf.jasperreports.style.isBold";
    public static final String STYLE_PROPERTY_FONT_ITALIC = "net.sf.jasperreports.style.isItalic";
    public static final String STYLE_PROPERTY_FONT_UNDERLINE = "net.sf.jasperreports.style.isUnderline";
    public static final String STYLE_PROPERTY_FONT_STRIKETHROUGH = "net.sf.jasperreports.style.isStrikeThrough";
    public static final String STYLE_PROPERTY_PDF_FONT_NAME = "net.sf.jasperreports.style.pdfFontName";
    public static final String STYLE_PROPERTY_PDF_ENCODING = "net.sf.jasperreports.style.pdfEncoding";
    public static final String STYLE_PROPERTY_PDF_EMBEDDED = "net.sf.jasperreports.style.isPdfEmbedded";
    public static final String STYLE_PROPERTY_PEN_LINE_WIDTH = "net.sf.jasperreports.style.pen.lineWidth";
    public static final String STYLE_PROPERTY_PEN_LINE_STYLE = "net.sf.jasperreports.style.pen.lineStyle";
    public static final String STYLE_PROPERTY_PEN_LINE_COLOR = "net.sf.jasperreports.style.pen.lineColor";
    public static final String STYLE_PROPERTY_BOX_PADDING = "net.sf.jasperreports.style.box.padding";
    public static final String STYLE_PROPERTY_BOX_TOP_PADDING = "net.sf.jasperreports.style.box.topPadding";
    public static final String STYLE_PROPERTY_BOX_LEFT_PADDING = "net.sf.jasperreports.style.box.leftPadding";
    public static final String STYLE_PROPERTY_BOX_RIGHT_PADDING = "net.sf.jasperreports.style.box.rightPadding";
    public static final String STYLE_PROPERTY_BOX_BOTTOM_PADDING = "net.sf.jasperreports.style.box.bottomPadding";
    public static final String STYLE_PROPERTY_BOX_PEN_LINE_WIDTH = "net.sf.jasperreports.style.box.pen.lineWidth";
    public static final String STYLE_PROPERTY_BOX_PEN_LINE_STYLE = "net.sf.jasperreports.style.box.pen.lineStyle";
    public static final String STYLE_PROPERTY_BOX_PEN_LINE_COLOR = "net.sf.jasperreports.style.box.pen.lineColor";
    public static final String STYLE_PROPERTY_BOX_LEFT_PEN_LINE_WIDTH = "net.sf.jasperreports.style.box.left.pen.lineWidth";
    public static final String STYLE_PROPERTY_BOX_LEFT_PEN_LINE_STYLE = "net.sf.jasperreports.style.box.left.pen.lineStyle";
    public static final String STYLE_PROPERTY_BOX_LEFT_PEN_LINE_COLOR = "net.sf.jasperreports.style.box.left.pen.lineColor";
    public static final String STYLE_PROPERTY_BOX_TOP_PEN_LINE_WIDTH = "net.sf.jasperreports.style.box.top.pen.lineWidth";
    public static final String STYLE_PROPERTY_BOX_TOP_PEN_LINE_STYLE = "net.sf.jasperreports.style.box.top.pen.lineStyle";
    public static final String STYLE_PROPERTY_BOX_TOP_PEN_LINE_COLOR = "net.sf.jasperreports.style.box.top.pen.lineColor";
    public static final String STYLE_PROPERTY_BOX_RIGHT_PEN_LINE_WIDTH = "net.sf.jasperreports.style.box.right.pen.lineWidth";
    public static final String STYLE_PROPERTY_BOX_RIGHT_PEN_LINE_STYLE = "net.sf.jasperreports.style.box.right.pen.lineStyle";
    public static final String STYLE_PROPERTY_BOX_RIGHT_PEN_LINE_COLOR = "net.sf.jasperreports.style.box.right.pen.lineColor";
    public static final String STYLE_PROPERTY_BOX_BOTTOM_PEN_LINE_WIDTH = "net.sf.jasperreports.style.box.bottom.pen.lineWidth";
    public static final String STYLE_PROPERTY_BOX_BOTTOM_PEN_LINE_STYLE = "net.sf.jasperreports.style.box.bottom.pen.lineStyle";
    public static final String STYLE_PROPERTY_BOX_BOTTOM_PEN_LINE_COLOR = "net.sf.jasperreports.style.box.bottom.pen.lineColor";
    public static final String STYLE_PROPERTY_LINE_SPACING = "net.sf.jasperreports.style.paragraph.lineSpacing";
    public static final String STYLE_PROPERTY_LINE_SPACING_SIZE = "net.sf.jasperreports.style.paragraph.lineSpacingSize";
    public static final String STYLE_PROPERTY_FIRST_LINE_INDENT = "net.sf.jasperreports.style.paragraph.firstLineIndent";
    public static final String STYLE_PROPERTY_LEFT_INDENT = "net.sf.jasperreports.style.paragraph.leftIndent";
    public static final String STYLE_PROPERTY_RIGHT_INDENT = "net.sf.jasperreports.style.paragraph.rightIndent";
    public static final String STYLE_PROPERTY_SPACING_BEFORE = "net.sf.jasperreports.style.paragraph.spacingBefore";
    public static final String STYLE_PROPERTY_SPACING_AFTER = "net.sf.jasperreports.style.paragraph.spacingAfter";
    public static final String STYLE_PROPERTY_TABSTOP_WIDTH = "net.sf.jasperreports.style.paragraph.tabStopWidth";
    private final StyleProviderContext context;
    private final Map<String, JRPropertyExpression> stylePropertyExpressions;
    private final String[] fields;
    private final String[] variables;
    private final boolean lateEvaluated;

    public PropertyStyleProvider(StyleProviderContext context, Map<String, JRPropertyExpression> stylePropertyExpressions) {
        this.context = context;
        this.stylePropertyExpressions = stylePropertyExpressions;
        ArrayList<String> fieldsList = new ArrayList<String>();
        ArrayList<String> variablesList = new ArrayList<String>();
        if (stylePropertyExpressions != null) {
            for (JRPropertyExpression stylePropertyExpression : stylePropertyExpressions.values()) {
                JRExpressionChunk[] chunks;
                JRExpression expression = stylePropertyExpression.getValueExpression();
                if (expression == null || (chunks = expression.getChunks()) == null) continue;
                block5: for (int i = 0; i < chunks.length; ++i) {
                    JRExpressionChunk chunk = chunks[i];
                    switch (chunk.getType()) {
                        case 3: {
                            fieldsList.add(chunk.getText());
                            continue block5;
                        }
                        case 4: {
                            variablesList.add(chunk.getText());
                            continue block5;
                        }
                    }
                }
            }
        }
        this.fields = fieldsList.size() > 0 ? fieldsList.toArray(new String[fieldsList.size()]) : null;
        this.variables = variablesList.size() > 0 ? variablesList.toArray(new String[variablesList.size()]) : null;
        JRElement element = context.getElement();
        JREvaluation evaluation = element instanceof JREvaluation ? (JREvaluation)((Object)element) : null;
        this.lateEvaluated = evaluation != null && evaluation.getEvaluationTimeValue() != EvaluationTimeEnum.NOW;
    }

    @Override
    public JRStyle getStyle(byte evaluation) {
        String tabStopWidth;
        String spacingAfter;
        String spacingBefore;
        String rightIndent;
        String leftIndent;
        String firstLineIndent;
        String lineSpacingSize;
        String lineSpacing;
        String boxBottomPenLineColor;
        String boxBottomPenLineStyle;
        String boxBottomPenLineWidth;
        String boxRightPenLineColor;
        String boxRightPenLineStyle;
        String boxRightPenLineWidth;
        String boxTopPenLineColor;
        String boxTopPenLineStyle;
        String boxTopPenLineWidth;
        String boxLeftPenLineColor;
        String boxLeftPenLineStyle;
        String boxLeftPenLineWidth;
        String boxPenLineColor;
        String boxPenLineStyle;
        String boxPenLineWidth;
        String boxBottomPadding;
        String boxRightPadding;
        String boxTopPadding;
        String boxLeftPadding;
        String boxPadding;
        String penLineColor;
        String penLineStyle;
        String penLineWidth;
        String pdfEmbedded;
        String pdfEncoding;
        String pdfFontName;
        String strikethrough;
        String underline;
        String italic;
        String bold;
        String fontSize;
        String fontName;
        String blankWhenNull;
        String pattern;
        String markup;
        String rotation;
        String vAlign;
        String hAlign;
        String scaleImage;
        String radius;
        String fill;
        String forecolor;
        String backcolor;
        JRBaseStyle style = new JRBaseStyle();
        String mode = this.getPropertyValue(STYLE_PROPERTY_MODE, evaluation);
        if (mode != null) {
            style.setMode(ModeEnum.getByName(mode));
        }
        if ((backcolor = this.getPropertyValue(STYLE_PROPERTY_BACKCOLOR, evaluation)) != null) {
            style.setBackcolor(JRColorUtil.getColor(backcolor, null));
        }
        if ((forecolor = this.getPropertyValue(STYLE_PROPERTY_FORECOLOR, evaluation)) != null) {
            style.setForecolor(JRColorUtil.getColor(forecolor, null));
        }
        if ((fill = this.getPropertyValue(STYLE_PROPERTY_FILL, evaluation)) != null) {
            style.setFill(FillEnum.getByName(fill));
        }
        if ((radius = this.getPropertyValue(STYLE_PROPERTY_RADIUS, evaluation)) != null) {
            style.setRadius(Integer.valueOf(radius));
        }
        if ((scaleImage = this.getPropertyValue(STYLE_PROPERTY_SCALE_IMAGE, evaluation)) != null) {
            style.setScaleImage(ScaleImageEnum.getByName(scaleImage));
        }
        if ((hAlign = this.getPropertyValue(STYLE_PROPERTY_HALIGN, evaluation)) != null) {
            style.setHorizontalTextAlign(HorizontalTextAlignEnum.getByName(hAlign));
            style.setHorizontalImageAlign(HorizontalImageAlignEnum.getByName(hAlign));
        }
        if ((hAlign = this.getPropertyValue(STYLE_PROPERTY_H_TEXT_ALIGN, evaluation)) != null) {
            style.setHorizontalTextAlign(HorizontalTextAlignEnum.getByName(hAlign));
        }
        if ((hAlign = this.getPropertyValue(STYLE_PROPERTY_H_IMAGE_ALIGN, evaluation)) != null) {
            style.setHorizontalImageAlign(HorizontalImageAlignEnum.getByName(hAlign));
        }
        if ((vAlign = this.getPropertyValue(STYLE_PROPERTY_VALIGN, evaluation)) != null) {
            style.setVerticalTextAlign(VerticalTextAlignEnum.getByName(vAlign));
            style.setVerticalImageAlign(VerticalImageAlignEnum.getByName(vAlign));
        }
        if ((vAlign = this.getPropertyValue(STYLE_PROPERTY_V_TEXT_ALIGN, evaluation)) != null) {
            style.setVerticalTextAlign(VerticalTextAlignEnum.getByName(vAlign));
        }
        if ((vAlign = this.getPropertyValue(STYLE_PROPERTY_V_IMAGE_ALIGN, evaluation)) != null) {
            style.setVerticalImageAlign(VerticalImageAlignEnum.getByName(vAlign));
        }
        if ((rotation = this.getPropertyValue(STYLE_PROPERTY_ROTATION, evaluation)) != null) {
            style.setRotation(RotationEnum.getByName(rotation));
        }
        if ((markup = this.getPropertyValue(STYLE_PROPERTY_MARKUP, evaluation)) != null) {
            style.setMarkup(markup);
        }
        if ((pattern = this.getPropertyValue(STYLE_PROPERTY_PATTERN, evaluation)) != null) {
            style.setPattern(pattern);
        }
        if ((blankWhenNull = this.getPropertyValue(STYLE_PROPERTY_BLANK_WHEN_NULL, evaluation)) != null) {
            style.setBlankWhenNull(Boolean.valueOf(blankWhenNull));
        }
        if ((fontName = this.getPropertyValue(STYLE_PROPERTY_FONT_NAME, evaluation)) != null) {
            style.setFontName(fontName);
        }
        if ((fontSize = this.getPropertyValue(STYLE_PROPERTY_FONT_SIZE, evaluation)) != null) {
            style.setFontSize(Float.valueOf(fontSize));
        }
        if ((bold = this.getPropertyValue(STYLE_PROPERTY_FONT_BOLD, evaluation)) != null) {
            style.setBold(Boolean.valueOf(bold));
        }
        if ((italic = this.getPropertyValue(STYLE_PROPERTY_FONT_ITALIC, evaluation)) != null) {
            style.setItalic(Boolean.valueOf(italic));
        }
        if ((underline = this.getPropertyValue(STYLE_PROPERTY_FONT_UNDERLINE, evaluation)) != null) {
            style.setUnderline(Boolean.valueOf(underline));
        }
        if ((strikethrough = this.getPropertyValue(STYLE_PROPERTY_FONT_STRIKETHROUGH, evaluation)) != null) {
            style.setStrikeThrough(Boolean.valueOf(strikethrough));
        }
        if ((pdfFontName = this.getPropertyValue(STYLE_PROPERTY_PDF_FONT_NAME, evaluation)) != null) {
            style.setPdfFontName(pdfFontName);
        }
        if ((pdfEncoding = this.getPropertyValue(STYLE_PROPERTY_PDF_ENCODING, evaluation)) != null) {
            style.setPdfEncoding(pdfEncoding);
        }
        if ((pdfEmbedded = this.getPropertyValue(STYLE_PROPERTY_PDF_EMBEDDED, evaluation)) != null) {
            style.setPdfEmbedded(Boolean.valueOf(pdfEmbedded));
        }
        if ((penLineWidth = this.getPropertyValue(STYLE_PROPERTY_PEN_LINE_WIDTH, evaluation)) != null) {
            style.getLinePen().setLineWidth(Float.valueOf(penLineWidth));
        }
        if ((penLineStyle = this.getPropertyValue(STYLE_PROPERTY_PEN_LINE_STYLE, evaluation)) != null) {
            style.getLinePen().setLineStyle(LineStyleEnum.getByName(penLineStyle));
        }
        if ((penLineColor = this.getPropertyValue(STYLE_PROPERTY_PEN_LINE_COLOR, evaluation)) != null) {
            style.getLinePen().setLineColor(JRColorUtil.getColor(penLineColor, null));
        }
        if ((boxPadding = this.getPropertyValue(STYLE_PROPERTY_BOX_PADDING, evaluation)) != null) {
            style.getLineBox().setPadding(Integer.valueOf(boxPadding));
        }
        if ((boxLeftPadding = this.getPropertyValue(STYLE_PROPERTY_BOX_LEFT_PADDING, evaluation)) != null) {
            style.getLineBox().setLeftPadding(Integer.valueOf(boxLeftPadding));
        }
        if ((boxTopPadding = this.getPropertyValue(STYLE_PROPERTY_BOX_TOP_PADDING, evaluation)) != null) {
            style.getLineBox().setTopPadding(Integer.valueOf(boxTopPadding));
        }
        if ((boxRightPadding = this.getPropertyValue(STYLE_PROPERTY_BOX_RIGHT_PADDING, evaluation)) != null) {
            style.getLineBox().setRightPadding(Integer.valueOf(boxRightPadding));
        }
        if ((boxBottomPadding = this.getPropertyValue(STYLE_PROPERTY_BOX_BOTTOM_PADDING, evaluation)) != null) {
            style.getLineBox().setBottomPadding(Integer.valueOf(boxBottomPadding));
        }
        if ((boxPenLineWidth = this.getPropertyValue(STYLE_PROPERTY_BOX_PEN_LINE_WIDTH, evaluation)) != null) {
            style.getLineBox().getPen().setLineWidth(Float.valueOf(boxPenLineWidth));
        }
        if ((boxPenLineStyle = this.getPropertyValue(STYLE_PROPERTY_BOX_PEN_LINE_STYLE, evaluation)) != null) {
            style.getLineBox().getPen().setLineStyle(LineStyleEnum.getByName(boxPenLineStyle));
        }
        if ((boxPenLineColor = this.getPropertyValue(STYLE_PROPERTY_BOX_PEN_LINE_COLOR, evaluation)) != null) {
            style.getLineBox().getPen().setLineColor(JRColorUtil.getColor(boxPenLineColor, null));
        }
        if ((boxLeftPenLineWidth = this.getPropertyValue(STYLE_PROPERTY_BOX_LEFT_PEN_LINE_WIDTH, evaluation)) != null) {
            style.getLineBox().getLeftPen().setLineWidth(Float.valueOf(boxLeftPenLineWidth));
        }
        if ((boxLeftPenLineStyle = this.getPropertyValue(STYLE_PROPERTY_BOX_LEFT_PEN_LINE_STYLE, evaluation)) != null) {
            style.getLineBox().getLeftPen().setLineStyle(LineStyleEnum.getByName(boxLeftPenLineStyle));
        }
        if ((boxLeftPenLineColor = this.getPropertyValue(STYLE_PROPERTY_BOX_LEFT_PEN_LINE_COLOR, evaluation)) != null) {
            style.getLineBox().getLeftPen().setLineColor(JRColorUtil.getColor(boxLeftPenLineColor, null));
        }
        if ((boxTopPenLineWidth = this.getPropertyValue(STYLE_PROPERTY_BOX_TOP_PEN_LINE_WIDTH, evaluation)) != null) {
            style.getLineBox().getTopPen().setLineWidth(Float.valueOf(boxTopPenLineWidth));
        }
        if ((boxTopPenLineStyle = this.getPropertyValue(STYLE_PROPERTY_BOX_TOP_PEN_LINE_STYLE, evaluation)) != null) {
            style.getLineBox().getTopPen().setLineStyle(LineStyleEnum.getByName(boxTopPenLineStyle));
        }
        if ((boxTopPenLineColor = this.getPropertyValue(STYLE_PROPERTY_BOX_TOP_PEN_LINE_COLOR, evaluation)) != null) {
            style.getLineBox().getTopPen().setLineColor(JRColorUtil.getColor(boxTopPenLineColor, null));
        }
        if ((boxRightPenLineWidth = this.getPropertyValue(STYLE_PROPERTY_BOX_RIGHT_PEN_LINE_WIDTH, evaluation)) != null) {
            style.getLineBox().getRightPen().setLineWidth(Float.valueOf(boxRightPenLineWidth));
        }
        if ((boxRightPenLineStyle = this.getPropertyValue(STYLE_PROPERTY_BOX_RIGHT_PEN_LINE_STYLE, evaluation)) != null) {
            style.getLineBox().getRightPen().setLineStyle(LineStyleEnum.getByName(boxRightPenLineStyle));
        }
        if ((boxRightPenLineColor = this.getPropertyValue(STYLE_PROPERTY_BOX_RIGHT_PEN_LINE_COLOR, evaluation)) != null) {
            style.getLineBox().getRightPen().setLineColor(JRColorUtil.getColor(boxRightPenLineColor, null));
        }
        if ((boxBottomPenLineWidth = this.getPropertyValue(STYLE_PROPERTY_BOX_BOTTOM_PEN_LINE_WIDTH, evaluation)) != null) {
            style.getLineBox().getBottomPen().setLineWidth(Float.valueOf(boxBottomPenLineWidth));
        }
        if ((boxBottomPenLineStyle = this.getPropertyValue(STYLE_PROPERTY_BOX_BOTTOM_PEN_LINE_STYLE, evaluation)) != null) {
            style.getLineBox().getBottomPen().setLineStyle(LineStyleEnum.getByName(boxBottomPenLineStyle));
        }
        if ((boxBottomPenLineColor = this.getPropertyValue(STYLE_PROPERTY_BOX_BOTTOM_PEN_LINE_COLOR, evaluation)) != null) {
            style.getLineBox().getBottomPen().setLineColor(JRColorUtil.getColor(boxBottomPenLineColor, null));
        }
        if ((lineSpacing = this.getPropertyValue(STYLE_PROPERTY_LINE_SPACING, evaluation)) != null) {
            style.getParagraph().setLineSpacing(LineSpacingEnum.getByName(lineSpacing));
        }
        if ((lineSpacingSize = this.getPropertyValue(STYLE_PROPERTY_LINE_SPACING_SIZE, evaluation)) != null) {
            style.getParagraph().setLineSpacingSize(Float.valueOf(lineSpacingSize));
        }
        if ((firstLineIndent = this.getPropertyValue(STYLE_PROPERTY_FIRST_LINE_INDENT, evaluation)) != null) {
            style.getParagraph().setFirstLineIndent(Integer.valueOf(firstLineIndent));
        }
        if ((leftIndent = this.getPropertyValue(STYLE_PROPERTY_LEFT_INDENT, evaluation)) != null) {
            style.getParagraph().setLeftIndent(Integer.valueOf(leftIndent));
        }
        if ((rightIndent = this.getPropertyValue(STYLE_PROPERTY_RIGHT_INDENT, evaluation)) != null) {
            style.getParagraph().setRightIndent(Integer.valueOf(rightIndent));
        }
        if ((spacingBefore = this.getPropertyValue(STYLE_PROPERTY_SPACING_BEFORE, evaluation)) != null) {
            style.getParagraph().setSpacingBefore(Integer.valueOf(spacingBefore));
        }
        if ((spacingAfter = this.getPropertyValue(STYLE_PROPERTY_SPACING_AFTER, evaluation)) != null) {
            style.getParagraph().setSpacingAfter(Integer.valueOf(spacingAfter));
        }
        if ((tabStopWidth = this.getPropertyValue(STYLE_PROPERTY_TABSTOP_WIDTH, evaluation)) != null) {
            style.getParagraph().setTabStopWidth(Integer.valueOf(spacingAfter));
        }
        return style;
    }

    @Override
    public String[] getFields() {
        return this.fields;
    }

    @Override
    public String[] getVariables() {
        return this.variables;
    }

    private String getPropertyValue(String propertyName, byte evaluation) {
        String value = null;
        if (this.lateEvaluated && this.stylePropertyExpressions != null && this.stylePropertyExpressions.containsKey(propertyName)) {
            JRPropertyExpression stylePropertyExpression = this.stylePropertyExpressions.get(propertyName);
            JRExpression expression = stylePropertyExpression.getValueExpression();
            if (expression != null) {
                value = (String)this.context.evaluateExpression(expression, evaluation);
            }
        } else {
            value = this.context.getElement().getPropertiesMap().getProperty(propertyName);
        }
        return value;
    }
}

