/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents.simplecorrelator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.ActionCheckBoxNodeData;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.ActionComboBoxNodeData;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.ActionProperty;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.ActionSpinnerNodeData;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.ActionTextFieldComboBoxNodeData;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.ParamsTabelModel;

public class ActionTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final Color changeColor = new Color(250, 212, 192);
    private JCheckBox checkBox = new JCheckBox();
    private JPanel panel;
    private JLabel label;
    private JComboBox comboBox;
    private JSpinner spinner = new JSpinner();
    private JTextField textField = new JTextField();

    public ActionTreeCellRenderer() {
        this.panel = new JPanel();
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setVgap(0);
        flowLayout.setHgap(0);
        this.panel.setLayout(flowLayout);
        this.label = new JLabel();
        this.label.setIcon(new ImageIcon(this.getClass().getResource("/application_form_edit.png")));
        this.panel.add(this.label);
        this.comboBox = new JComboBox();
        this.panel.add(this.comboBox);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        Object node = ((DefaultMutableTreeNode)value).getUserObject();
        if (node instanceof ActionCheckBoxNodeData) {
            this.setCheckBoxComponent(node);
            return this.checkBox;
        }
        if (node instanceof ActionComboBoxNodeData) {
            ActionComboBoxNodeData acbnd = (ActionComboBoxNodeData)node;
            this.setComboBoxComponent(acbnd);
            return this.panel;
        }
        if (node instanceof ActionSpinnerNodeData) {
            ActionSpinnerNodeData asnd = (ActionSpinnerNodeData)node;
            this.setSpinnerComponent(asnd);
            return this.panel;
        }
        if (node instanceof ActionTextFieldComboBoxNodeData) {
            ActionTextFieldComboBoxNodeData acbnd = (ActionTextFieldComboBoxNodeData)node;
            this.setTextComboBoxComponent(acbnd);
            return this.panel;
        }
        if (node instanceof ParamsTabelModel.Item) {
            this.setIcon(new ImageIcon(this.getClass().getResource("/table_edit.png")));
        }
        if (node instanceof ActionProperty) {
            if (((ActionProperty)node).isEditable()) {
                this.setIcon(new ImageIcon(this.getClass().getResource("/application_form_edit.png")));
            }
            if (((ActionProperty)node).isEditable() && !((ActionProperty)node).isChanged()) {
                this.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, this.changeColor));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder());
            }
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
        return this;
    }

    private void setSpinnerComponent(ActionSpinnerNodeData asnd) {
        this.clearPanel();
        this.label.setText(asnd.getProperty());
        this.setPanelBackgroundAndForeground();
        this.spinner.setModel(new SpinnerNumberModel(asnd.getValue(), asnd.getMinValue(), asnd.getMaxValue(), asnd.getStepSize()));
        this.panel.add(this.spinner);
    }

    private void setPanelBackgroundAndForeground() {
        if (this.selected) {
            this.panel.setForeground(this.getTextSelectionColor());
            this.panel.setBackground(this.getBackgroundSelectionColor());
        } else {
            this.panel.setForeground(this.getTextNonSelectionColor());
            this.panel.setBackground(this.getBackgroundNonSelectionColor());
        }
    }

    private void setComboBoxComponent(ActionComboBoxNodeData acbnd) {
        this.clearPanel();
        this.label.setText(acbnd.getProperty());
        this.comboBox.removeAllItems();
        for (String value : acbnd.getValues()) {
            this.comboBox.addItem(value);
        }
        this.comboBox.setSelectedIndex(acbnd.getSelectedIndex());
        this.panel.add(this.comboBox);
        this.setPanelBackgroundAndForeground();
    }

    private void setTextComboBoxComponent(ActionTextFieldComboBoxNodeData acbnd) {
        this.clearPanel();
        this.label.setText(acbnd.getProperty());
        this.comboBox.removeAllItems();
        for (String value : acbnd.getValues()) {
            this.comboBox.addItem(value);
        }
        this.comboBox.setSelectedIndex(acbnd.getSelectedIndex());
        this.textField.setText(acbnd.getText());
        this.textField.setPreferredSize(new Dimension(100, 24));
        this.panel.add(this.textField);
        this.panel.add(this.comboBox);
        this.setPanelBackgroundAndForeground();
    }

    private void clearPanel() {
        for (int i = 1; i < this.panel.getComponentCount(); ++i) {
            this.panel.remove(1);
        }
    }

    private void setCheckBoxComponent(Object node) {
        ActionCheckBoxNodeData acbnd = (ActionCheckBoxNodeData)node;
        this.checkBox.setText(acbnd.getValue());
        this.checkBox.setSelected(acbnd.isSelected());
        this.checkBox.setBorderPaintedFlat(true);
        this.checkBox.setEnabled(acbnd.isEditable());
        if (this.selected) {
            this.checkBox.setForeground(this.getTextSelectionColor());
            this.checkBox.setBackground(this.getBackgroundSelectionColor());
        } else {
            this.checkBox.setForeground(this.getTextNonSelectionColor());
            this.checkBox.setBackground(this.getBackgroundNonSelectionColor());
        }
    }
}

