/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents.search;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.api.service.IndexDateRange;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.gui.module.alertevents.search.SearchResults;
import rs.co.ast.aspen.gui.module.alertevents.search.SkippedTaskDelays;
import rs.co.ast.aspen.gui.module.alertevents.search.SkippedTaskInfo;
import rs.co.ast.aspen.gui.module.alertevents.search.TaskMonitor;

public class SearchContext {
    private SkippedTaskDelays skippedTaskDelayes = new SkippedTaskDelays();
    private SearchResults searchResults = new SearchResults();
    private TaskMonitor taskMonitor = new TaskMonitor();
    private List<IndexDateRange> indexDateIntervals;
    private List<DateRange> dateRanges;
    private PropertyChangeListener propertyChangeListener;
    private Map<DateRange, SearchState> searchStateForDateRange = new ConcurrentHashMap<DateRange, SearchState>();
    private List<SkippedTaskInfo> skippedTasks = new ArrayList<SkippedTaskInfo>();

    public SearchContext(int pageSize, boolean sortAsc, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListener = propertyChangeListener;
        this.searchResults.addPropertyChangeListener(propertyChangeListener);
        this.searchResults.setPageSize(pageSize);
        this.searchResults.setSortAsc(sortAsc);
        this.taskMonitor.addPropertyChangeListener(propertyChangeListener);
    }

    public SkippedTaskDelays getSkippedTaskDelayes() {
        return this.skippedTaskDelayes;
    }

    public SearchResults getSearchResults() {
        return this.searchResults;
    }

    public TaskMonitor getTaskMonitor() {
        return this.taskMonitor;
    }

    public List<IndexDateRange> getIndexDateIntervals() {
        return this.indexDateIntervals;
    }

    public void setIndexDateIntervals(List<IndexDateRange> indexDateIntervals) {
        this.indexDateIntervals = indexDateIntervals;
        if (this.dateRanges == null) {
            this.dateRanges = new ArrayList<DateRange>();
        }
        for (IndexDateRange idr : this.indexDateIntervals) {
            for (DateRange dr : idr.getDateRanges()) {
                this.dateRanges.add(dr);
            }
        }
        if (!this.searchResults.isSortAsc()) {
            Collections.reverse(this.dateRanges);
        }
    }

    public List<DateRange> getDateRanges() {
        return this.dateRanges;
    }

    public void resetIndexDateIntervals() {
        this.indexDateIntervals = null;
    }

    public PropertyChangeListener getPropertyChangeListener() {
        return this.propertyChangeListener;
    }

    public Map<DateRange, SearchState> getSearchStateForDateRange() {
        return this.searchStateForDateRange;
    }

    public List<SkippedTaskInfo> getSkippedTasks() {
        return this.skippedTasks;
    }
}

