/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.chart;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.event.EventListenerList;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import rs.co.ast.chart.event.ASTMouseEvent;
import rs.co.ast.chart.event.ASTMouseListener;
import rs.co.ast.chart.event.ASTPlotChangeEvent;
import rs.co.ast.chart.event.ASTPlotChangeListener;

public abstract class ASTChart
implements PlotChangeListener,
MouseListener {
    public static final Color[] COLORS = new Color[]{new Color(65, 164, 133), new Color(80, 109, 175), new Color(252, 148, 29), new Color(225, 67, 5), new Color(247, 32, 8), new Color(56, 111, 101), new Color(43, 43, 85), new Color(252, 141, 98), new Color(250, 93, 30), new Color(212, 43, 147), new Color(132, 187, 42), new Color(255, 208, 0), new Color(205, 143, 50), new Color(255, 26, 102), new Color(230, 115, 0), new Color(255, 170, 1), new Color(0, 195, 0), new Color(26, 102, 255), new Color(153, 0, 0), new Color(0, 0, 79)};
    protected JFreeChart chart;
    protected ChartPanel chartPanel;
    protected XYPlot plot;
    private EventListenerList listenerList;

    public ASTChart() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void removeAllListeners() {
        ASTMouseListener[] listeners2;
        ASTPlotChangeListener[] listeners1;
        for (ASTPlotChangeListener o : listeners1 = (ASTPlotChangeListener[])this.listenerList.getListeners(ASTPlotChangeListener.class)) {
            this.listenerList.remove(ASTPlotChangeListener.class, o);
        }
        for (ASTMouseListener o : listeners2 = (ASTMouseListener[])this.listenerList.getListeners(ASTMouseListener.class)) {
            this.listenerList.remove(ASTMouseListener.class, o);
        }
    }

    public void addPlotChangeListener(ASTPlotChangeListener listener) {
        this.listenerList.add(ASTPlotChangeListener.class, listener);
    }

    private void firePlotChangeEvent(ASTPlotChangeEvent event) {
        ASTPlotChangeListener[] listeners = (ASTPlotChangeListener[])this.listenerList.getListeners(ASTPlotChangeListener.class);
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (!(listeners[i] instanceof ASTPlotChangeListener)) continue;
            listeners[i].plotChanged(event);
        }
    }

    public void addChartPanelMouseListener(ASTMouseListener listener) {
        this.listenerList.add(ASTMouseListener.class, listener);
    }

    private void fireMousePressedEvent(ASTMouseEvent event) {
        ASTMouseListener[] listeners = (ASTMouseListener[])this.listenerList.getListeners(ASTMouseListener.class);
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (!(listeners[i] instanceof ASTMouseListener) || event.getMouseEventType() != ASTMouseEvent.MouseEventType.MOUSE_PRESSED) continue;
            listeners[i].mousePressed(event);
        }
    }

    private void fireMouseReleasedEvent(ASTMouseEvent event) {
        ASTMouseListener[] listeners = (ASTMouseListener[])this.listenerList.getListeners(ASTMouseListener.class);
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (!(listeners[i] instanceof ASTMouseListener) || event.getMouseEventType() != ASTMouseEvent.MouseEventType.MOUSE_RELEASED) continue;
            listeners[i].mouseReleased(event);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.fireMousePressedEvent(new ASTMouseEvent(e, (Plot)this.plot, ASTMouseEvent.MouseEventType.MOUSE_PRESSED));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.fireMouseReleasedEvent(new ASTMouseEvent(e, (Plot)this.plot, ASTMouseEvent.MouseEventType.MOUSE_RELEASED));
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void plotChanged(PlotChangeEvent event) {
        this.firePlotChangeEvent(new ASTPlotChangeEvent(event));
    }
}

