/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.chart;

import java.awt.Paint;
import java.awt.event.MouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import rs.co.ast.chart.ASTChart;

public class OverviewChart
extends ASTChart {
    private TimeSeriesCollection dataset = new TimeSeriesCollection();
    private XYLineAndShapeRenderer renderer;

    public OverviewChart(TimeSeries ... ts) {
        for (TimeSeries s : ts) {
            this.dataset.addSeries(s);
        }
        DateAxis timeAxis = new DateAxis();
        timeAxis.setLowerMargin(0.02);
        timeAxis.setUpperMargin(0.02);
        NumberAxis valueAxis = new NumberAxis();
        valueAxis.setAutoRangeIncludesZero(true);
        this.renderer = new XYLineAndShapeRenderer(true, true);
        this.renderer.setAutoPopulateSeriesPaint(false);
        this.renderer.setAutoPopulateSeriesShape(true);
        for (int i = 0; i < this.dataset.getSeriesCount(); ++i) {
            this.renderer.setSeriesPaint(i, (Paint)COLORS[i]);
        }
        this.plot = new XYPlot((XYDataset)this.dataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, (XYItemRenderer)this.renderer);
        this.plot.addChangeListener((PlotChangeListener)this);
        this.chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.plot, false);
        new StandardChartTheme("JFree").apply(this.chart);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.addMouseListener((MouseListener)this);
    }

    public void updateChart(TimeSeries ... ts) {
        this.chartPanel.restoreAutoBounds();
        this.dataset.removeAllSeries();
        for (TimeSeries t : ts) {
            this.dataset.addSeries(t);
        }
        for (int i = 0; i < this.dataset.getSeriesCount(); ++i) {
            this.renderer.setSeriesPaint(i, (Paint)COLORS[i]);
        }
        this.chartPanel.repaint();
    }
}

