/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.visualization.properties;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import rs.co.ast.aspen.core.module.visengine.VisualizationException;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.gui.module.visualization.Consumer;
import rs.co.ast.aspen.gui.module.visualization.properties.HistoricalProducer;
import rs.co.ast.aspen.gui.module.visualization.properties.Producer;
import rs.co.ast.aspen.gui.module.visualization.properties.RealtimeProducer;

public class NodeManager {
    private static final Logger LOGGER = Logger.getLogger(NodeManager.class.getName());
    private static final int CAPACITY = 1000;
    private static Consumer consumer;
    private static Producer producer;
    private static final BlockingQueue<List<Node>> SHARED_QUEUE;

    public static NodeManager getInstance(boolean realtime) {
        if (producer != null) {
            try {
                producer.stopThread();
                producer.join();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (consumer != null) {
            try {
                consumer.stopThread();
                consumer.join();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        SHARED_QUEUE.clear();
        if (producer != null) {
            producer.stopThread();
        }
        producer = realtime ? new RealtimeProducer(SHARED_QUEUE) : new HistoricalProducer(SHARED_QUEUE);
        if (consumer != null) {
            consumer.stopThread();
        }
        consumer = new Consumer(SHARED_QUEUE);
        return NodeManagerHolder.INSTANCE;
    }

    private NodeManager() {
    }

    public void changeMode(Producer.Mode mode) {
        producer.changeMode(mode);
    }

    public void nextStep() throws InterruptedException, VisualizationException {
        producer.nextStep();
    }

    public void pause() {
        producer.sleep();
        consumer.pause();
    }

    public void start() {
        this.stop();
        producer.start();
        consumer.start();
    }

    public void stop() {
        try {
            producer.stopThread();
            producer.join();
            consumer.stopThread();
            consumer.join();
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        LOGGER.info("Queue cleared!");
        SHARED_QUEUE.clear();
        producer.wake();
        consumer.unpause();
    }

    public void unpause() {
        producer.changeMode(Producer.Mode.NORMAL);
        producer.wake();
        consumer.unpause();
    }

    public void unpauseConsumer() {
        consumer.unpause();
    }

    public void clearQueue() {
        SHARED_QUEUE.clear();
    }

    public void updateEventsPerStep(int eps) {
        producer.updateEventsPerStep(eps);
    }

    public void updateFinishDate(long finishDate) {
        producer.updateFinishDate(finishDate);
    }

    public void updateStartDate(long startDate) {
        producer.updateStartDate(startDate);
    }

    public void updateStepDelay(long delay) {
        producer.updateStepDelay(delay);
    }

    static {
        SHARED_QUEUE = new LinkedBlockingQueue<List<Node>>(1000);
    }

    private static class NodeManagerHolder {
        protected static final NodeManager INSTANCE = new NodeManager();

        private NodeManagerHolder() {
        }
    }
}

