/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.control;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.light.SpotLight;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.control.AbstractControl;
import com.jme3.util.TempVars;
import com.jme3.util.clone.Cloner;
import java.io.IOException;

public class LightControl
extends AbstractControl {
    private static final String CONTROL_DIR_NAME = "controlDir";
    private static final String LIGHT_NAME = "light";
    private Light light;
    private ControlDirection controlDir = ControlDirection.SpatialToLight;

    public LightControl() {
    }

    public LightControl(Light light) {
        this.light = light;
    }

    public LightControl(Light light, ControlDirection controlDir) {
        this.light = light;
        this.controlDir = controlDir;
    }

    public Light getLight() {
        return this.light;
    }

    public void setLight(Light light) {
        this.light = light;
    }

    public ControlDirection getControlDir() {
        return this.controlDir;
    }

    public void setControlDir(ControlDirection controlDir) {
        this.controlDir = controlDir;
    }

    @Override
    protected void controlUpdate(float tpf) {
        if (this.spatial != null && this.light != null) {
            switch (this.controlDir) {
                case SpatialToLight: {
                    this.spatialToLight(this.light);
                    break;
                }
                case LightToSpatial: {
                    this.lightToSpatial(this.light);
                }
            }
        }
    }

    private void spatialToLight(Light light) {
        Vector3f worldTranslation = this.spatial.getWorldTranslation();
        if (light instanceof PointLight) {
            ((PointLight)light).setPosition(worldTranslation);
            return;
        }
        TempVars vars = TempVars.get();
        Vector3f vec = vars.vect1;
        if (light instanceof DirectionalLight) {
            ((DirectionalLight)light).setDirection(vec.set(worldTranslation).multLocal(-1.0f));
        }
        if (light instanceof SpotLight) {
            SpotLight spotLight = (SpotLight)light;
            spotLight.setPosition(worldTranslation);
            spotLight.setDirection(this.spatial.getWorldRotation().multLocal(vec.set(Vector3f.UNIT_Y).multLocal(-1.0f)));
        }
        vars.release();
    }

    private void lightToSpatial(Light light) {
        Vector3f vecDiff;
        TempVars vars = TempVars.get();
        if (light instanceof PointLight) {
            PointLight pLight = (PointLight)light;
            vecDiff = vars.vect1.set(pLight.getPosition()).subtractLocal(this.spatial.getWorldTranslation());
            this.spatial.setLocalTranslation(vecDiff.addLocal(this.spatial.getLocalTranslation()));
        }
        if (light instanceof DirectionalLight) {
            DirectionalLight dLight = (DirectionalLight)light;
            vars.vect1.set(dLight.getDirection()).multLocal(-1.0f);
            vecDiff = vars.vect1.subtractLocal(this.spatial.getWorldTranslation());
            this.spatial.setLocalTranslation(vecDiff.addLocal(this.spatial.getLocalTranslation()));
        }
        vars.release();
    }

    @Override
    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.light = cloner.clone(this.light);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.controlDir = ic.readEnum(CONTROL_DIR_NAME, ControlDirection.class, ControlDirection.SpatialToLight);
        this.light = (Light)ic.readSavable(LIGHT_NAME, null);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.controlDir, CONTROL_DIR_NAME, ControlDirection.SpatialToLight);
        oc.write(this.light, LIGHT_NAME, null);
    }

    public static enum ControlDirection {
        LightToSpatial,
        SpatialToLight;

    }
}

