/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.Buffer;
import com.jme3.opencl.CommandQueue;
import com.jme3.opencl.Context;
import com.jme3.opencl.Device;
import com.jme3.opencl.Image;
import com.jme3.opencl.MemoryAccess;
import com.jme3.opencl.OpenCLObject;
import com.jme3.opencl.Program;
import com.jme3.opencl.lwjgl.LwjglBuffer;
import com.jme3.opencl.lwjgl.LwjglCommandQueue;
import com.jme3.opencl.lwjgl.LwjglDevice;
import com.jme3.opencl.lwjgl.LwjglImage;
import com.jme3.opencl.lwjgl.LwjglProgram;
import com.jme3.opencl.lwjgl.Utils;
import com.jme3.scene.VertexBuffer;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Texture;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL10GL;
import org.lwjgl.opencl.CL12;
import org.lwjgl.opencl.CL12GL;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLMem;
import org.lwjgl.opencl.CLProgram;

public class LwjglContext
extends Context {
    private static final Logger LOG = Logger.getLogger(LwjglContext.class.getName());
    private final CLContext context;
    private final List<LwjglDevice> devices;

    public LwjglContext(CLContext context, List<LwjglDevice> devices) {
        super((OpenCLObject.ObjectReleaser)new ReleaserImpl(context, devices));
        this.context = context;
        this.devices = devices;
    }

    public CLContext getContext() {
        return this.context;
    }

    public List<LwjglDevice> getDevices() {
        return this.devices;
    }

    public CommandQueue createQueue(Device device) {
        assert (this.devices.contains(device));
        CLDevice d = ((LwjglDevice)device).getDevice();
        long properties = 0L;
        CLCommandQueue q = CL10.clCreateCommandQueue((CLContext)this.context, (CLDevice)d, (long)properties, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateCommandQueue");
        return new LwjglCommandQueue(q, device);
    }

    public Buffer createBuffer(long size, MemoryAccess access) {
        long flags = Utils.getMemoryAccessFlags(access);
        CLMem mem = CL10.clCreateBuffer((CLContext)this.context, (long)flags, (long)size, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateBuffer");
        return new LwjglBuffer(mem);
    }

    public Buffer createBufferFromHost(ByteBuffer data, MemoryAccess access) {
        long flags = Utils.getMemoryAccessFlags(access);
        CLMem mem = CL10.clCreateBuffer((CLContext)this.context, (long)(flags |= 8L), (ByteBuffer)data, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateBuffer");
        return new LwjglBuffer(mem);
    }

    public Image createImage(MemoryAccess access, Image.ImageFormat format, Image.ImageDescriptor descr) {
        long memFlags = Utils.getMemoryAccessFlags(access);
        Utils.errorBuffer.rewind();
        Utils.tempBuffers[0].b16i.rewind();
        Utils.tempBuffers[0].b16i.put(LwjglImage.decodeImageChannelOrder(format.channelOrder)).put(LwjglImage.decodeImageChannelType(format.channelType));
        Utils.tempBuffers[0].b16.rewind();
        Utils.b80l.rewind();
        Utils.b80l.put(LwjglImage.decodeImageType(descr.type)).put(descr.width).put(descr.height).put(descr.depth).put(descr.arraySize).put(descr.rowPitch).put(descr.slicePitch).put(0L).put(0L).put(0L);
        Utils.b80.rewind();
        CLMem mem = CL12.clCreateImage((CLContext)this.context, (long)memFlags, (ByteBuffer)Utils.tempBuffers[0].b16, (ByteBuffer)Utils.b80, (ByteBuffer)descr.hostPtr, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateImage");
        return new LwjglImage(mem);
    }

    public Image.ImageFormat[] querySupportedFormats(MemoryAccess access, Image.ImageType type) {
        long memFlags = Utils.getMemoryAccessFlags(access);
        int typeFlag = LwjglImage.decodeImageType(type);
        Utils.tempBuffers[0].b16i.rewind();
        int ret = CL10.clGetSupportedImageFormats((CLContext)this.context, (long)memFlags, (int)typeFlag, null, (IntBuffer)Utils.tempBuffers[0].b16i);
        Utils.checkError(ret, "clGetSupportedImageFormats");
        int count = Utils.tempBuffers[0].b16i.get(0);
        if (count == 0) {
            return new Image.ImageFormat[0];
        }
        ByteBuffer formatsB = BufferUtils.createByteBuffer((int)(count * 8));
        ret = CL10.clGetSupportedImageFormats((CLContext)this.context, (long)memFlags, (int)typeFlag, (ByteBuffer)formatsB, null);
        Utils.checkError(ret, "clGetSupportedImageFormats");
        Image.ImageFormat[] formats = new Image.ImageFormat[count];
        IntBuffer formatsBi = formatsB.asIntBuffer();
        formatsBi.rewind();
        for (int i = 0; i < count; ++i) {
            Image.ImageChannelOrder channelOrder = LwjglImage.encodeImageChannelOrder(formatsBi.get());
            Image.ImageChannelType channelType = LwjglImage.encodeImageChannelType(formatsBi.get());
            formats[i] = new Image.ImageFormat(channelOrder, channelType);
        }
        return formats;
    }

    public Buffer bindVertexBuffer(VertexBuffer vb, MemoryAccess access) {
        int id = vb.getId();
        if (id == -1) {
            throw new IllegalArgumentException("vertex buffer was not yet uploaded to the GPU or is CPU only");
        }
        long flags = Utils.getMemoryAccessFlags(access);
        Utils.errorBuffer.rewind();
        CLMem mem = CL10GL.clCreateFromGLBuffer((CLContext)this.context, (long)flags, (int)id, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateFromGLBuffer");
        return new LwjglBuffer(mem);
    }

    public Image bindImage(com.jme3.texture.Image image, Texture.Type textureType, int miplevel, MemoryAccess access) {
        int imageID = image.getId();
        if (imageID == -1) {
            throw new IllegalArgumentException("image was not yet uploaded to the GPU");
        }
        long memFlags = Utils.getMemoryAccessFlags(access);
        int textureTarget = this.convertTextureType(textureType);
        Utils.errorBuffer.rewind();
        CLMem mem = CL12GL.clCreateFromGLTexture((CLContext)this.context, (long)memFlags, (int)textureTarget, (int)miplevel, (int)imageID, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateFromGLTexture");
        return new LwjglImage(mem);
    }

    protected Image bindPureRenderBuffer(FrameBuffer.RenderBuffer buffer, MemoryAccess access) {
        int renderbuffer = buffer.getId();
        if (renderbuffer == -1) {
            throw new IllegalArgumentException("renderbuffer was not yet uploaded to the GPU");
        }
        long memFlags = Utils.getMemoryAccessFlags(access);
        Utils.errorBuffer.rewind();
        CLMem mem = CL10GL.clCreateFromGLRenderbuffer((CLContext)this.context, (long)memFlags, (int)renderbuffer, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateFromGLRenderbuffer");
        return new LwjglImage(mem);
    }

    private int convertTextureType(Texture.Type textureType) {
        switch (textureType) {
            case TwoDimensional: {
                return 3553;
            }
            case TwoDimensionalArray: {
                return 35866;
            }
            case ThreeDimensional: {
                return 32879;
            }
            case CubeMap: {
                return 34067;
            }
        }
        throw new IllegalArgumentException("unknown texture type " + textureType);
    }

    public Program createProgramFromSourceCode(String sourceCode) {
        LOG.log(Level.FINE, "Create program from source:\n{0}", sourceCode);
        Utils.errorBuffer.rewind();
        CLProgram p = CL10.clCreateProgramWithSource((CLContext)this.context, (CharSequence)sourceCode, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateProgramWithSource");
        return new LwjglProgram(p, this);
    }

    public Program createProgramFromBinary(ByteBuffer binaries, Device device) {
        Utils.errorBuffer.rewind();
        Utils.tempBuffers[0].b16i.rewind();
        CLProgram p = CL10.clCreateProgramWithBinary((CLContext)this.context, (CLDevice)((LwjglDevice)device).device, (ByteBuffer)binaries, (IntBuffer)Utils.tempBuffers[0].b16i, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateProgramWithBinary");
        Utils.checkError(Utils.tempBuffers[0].b16i, "clCreateProgramWithBinary");
        return new LwjglProgram(p, this);
    }

    private static class ReleaserImpl
    implements OpenCLObject.ObjectReleaser {
        private CLContext context;
        private final List<LwjglDevice> devices;

        private ReleaserImpl(CLContext mem, List<LwjglDevice> devices) {
            this.context = mem;
            this.devices = devices;
        }

        public void release() {
            if (this.context != null) {
                int ret = CL10.clReleaseContext((CLContext)this.context);
                this.context = null;
                this.devices.clear();
                Utils.reportError(ret, "clReleaseMemObject");
            }
        }
    }
}

