/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.phys;

import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import java.util.Collection;
import java.util.List;
import rs.co.ast.aspen.core.module.visengine.graph.Edge;
import rs.co.ast.aspen.gui.module.vis.threed.phys.FieldMatrix;
import rs.co.ast.aspen.gui.module.vis.threed.phys.PhysicsBody;
import rs.co.ast.aspen.gui.module.vis.threed.phys.PhysicsConstants;

public class PhysicsSimulator {
    private final Vector3f Fdamp = new Vector3f();
    private final Vector3f Ffield1 = new Vector3f();
    private final Vector3f Fspring = new Vector3f();
    private final Vector3f Fspring1 = new Vector3f();
    private final Vector3f a = new Vector3f();
    private final PhysicsConstants constants;
    private final Vector3f dp = new Vector3f();
    private final Vector3f dv = new Vector3f();
    private final FieldMatrix fieldMatrix;
    private final Vector3f r = new Vector3f();
    private final Vector3f r_unit = new Vector3f();
    private Vector3f[] totalForce;

    public PhysicsSimulator(PhysicsConstants constants, FieldMatrix fieldMatrix) {
        this.constants = constants;
        this.fieldMatrix = fieldMatrix;
    }

    public boolean update(float dt, List<PhysicsBody> bodies, boolean debug) {
        if (this.totalForce == null || this.totalForce.length < bodies.size()) {
            this.totalForce = new Vector3f[bodies.size()];
        }
        this.zero(this.totalForce);
        for (int i = 0; i < bodies.size(); ++i) {
            PhysicsBody b1 = bodies.get(i);
            for (int j = i + 1; j < bodies.size(); ++j) {
                PhysicsBody b2 = bodies.get(j);
                this.r.set(b1.position.subtract(b2.position));
                this.r_unit.set(this.r).normalizeLocal();
                if (b1.charge != PhysicsBody.Charge._0 && b2.charge != PhysicsBody.Charge._0) {
                    this.applyField(this.Ffield1, b1, b2, this.r, this.r_unit);
                }
                this.applySprings(this.Fspring1, b1, b2, this.r, this.r_unit);
                if (this.Ffield1.length() > 0.0f) {
                    this.damp(b1, this.Ffield1, this.constants.FIELD_DAMPING);
                }
                if (this.Fspring1.length() > 0.0f) {
                    this.damp(b1, this.Fspring1, this.constants.SPRING_DAMPING);
                }
                this.totalForce[i].addLocal(this.Ffield1).addLocal(this.Fspring1);
                this.totalForce[j].addLocal(this.Ffield1.negateLocal()).addLocal(this.Fspring1.negateLocal());
            }
            this.forceActOnNode(b1, this.totalForce[i], dt);
            this.damp(b1, b1.velocity, this.constants.VELOCITY_DAMPING);
        }
        return true;
    }

    private void applyField(Vector3f F, PhysicsBody b1, PhysicsBody b2, Vector3f r, Vector3f r_unit) {
        float K = -this.constants.Kf * (float)this.fieldMatrix.get(b1.charge, b2.charge);
        float minDist = b1.radius + b2.radius;
        float rc = r.length();
        if (rc < minDist) {
            rc = minDist;
            K = this.constants.Kf * (1.0f - rc / minDist);
        }
        F.set(r_unit).multLocal(K * b1.mass * b2.mass / FastMath.sqr((float)rc));
    }

    private void applySprings(Vector3f F, PhysicsBody b1, PhysicsBody b2, Vector3f r, Vector3f r_unit) {
        Collection edges = b1.node.commonEdges(b2.node);
        F.set(Vector3f.ZERO);
        for (Edge e : edges) {
            float K = Float.parseFloat(e.get("%stiffness", String.valueOf(this.constants.DEFAULT_Ke)));
            float L = Float.parseFloat(e.get("%length", String.valueOf(this.constants.DEFAULT_SPRING_LEN)));
            float x = L - r.length();
            this.Fspring.set(r_unit).multLocal(K * x);
            F.addLocal(this.Fspring);
        }
    }

    private float clamp(float x, float min, float max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    private void clamp(Vector3f v, float min, float max) {
        v.x = this.clamp(v.x, min, max);
        v.y = this.clamp(v.y, min, max);
        v.z = this.clamp(v.z, min, max);
    }

    private void damp(PhysicsBody n, Vector3f v, float k) {
        if (k > 0.0f) {
            this.Fdamp.set(n.velocity).multLocal(k);
            v.subtractLocal(this.Fdamp);
        }
    }

    private void forceActOnNode(PhysicsBody body, Vector3f F, float dt) {
        if (body.node.get("fixed", "false").equalsIgnoreCase("true")) {
            return;
        }
        this.a.set(F).divideLocal(body.mass);
        this.dv.set(this.a).multLocal(dt);
        body.velocity.addLocal(this.dv);
        this.clamp(body.velocity, -this.constants.MAX_SPEED, this.constants.MAX_SPEED);
        this.dp.set(body.velocity).multLocal(dt).addLocal(this.a.multLocal(2.0f * FastMath.sqr((float)dt)));
        body.position.addLocal(this.dp);
    }

    private void zero(Vector3f[] v) {
        for (int i = 0; i < v.length; ++i) {
            if (v[i] == null) {
                v[i] = new Vector3f();
                continue;
            }
            v[i].zero();
        }
    }
}

