/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.pus;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;
import rs.co.ast.aspen.api.service.PusReports;

public class VisibleNodesModel {
    private Map<String, Boolean> processNodeVisibleStateMap = new HashMap<String, Boolean>();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final String PROP_NODE_CHECKED = "nodeChecked";
    public static final String PROP_ALL_NODES_CHECKED = "allNodesChecked";

    public void setNodesVisibleStateModel(PusReports reports) {
        Preferences p = NbPreferences.forModule(VisibleNodesModel.class);
        List nodes = reports.getNodes();
        nodes.stream().forEach(pn -> pn.getProcesses().stream().forEach(pp -> {
            boolean isVisible = p.getBoolean("serverMonitor_" + pp.getName(), true);
            this.processNodeVisibleStateMap.put(pp.getName(), isVisible);
        }));
    }

    public Map<String, Boolean> getProcessNodeVisibleStateMap() {
        return this.processNodeVisibleStateMap;
    }

    public void updateVisibility(String pusProcessName, boolean visible) {
        this.processNodeVisibleStateMap.put(pusProcessName, visible);
        Preferences p = NbPreferences.forModule(VisibleNodesModel.class);
        p.putBoolean("serverMonitor_" + pusProcessName, visible);
        this.pcs.firePropertyChange(PROP_NODE_CHECKED, null, null);
    }

    public boolean getNodeVisibility(String pusProcessName) {
        return this.processNodeVisibleStateMap.get(pusProcessName);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void setAllNodesChecked(boolean b) {
        Preferences p = NbPreferences.forModule(VisibleNodesModel.class);
        for (Map.Entry<String, Boolean> entry : this.processNodeVisibleStateMap.entrySet()) {
            this.processNodeVisibleStateMap.put(entry.getKey(), b);
            p.putBoolean("serverMonitor_" + entry.getKey(), b);
        }
        this.pcs.firePropertyChange(PROP_ALL_NODES_CHECKED, null, null);
    }
}

